/*
 * Decompiled with CFR 0.152.
 */
package ej.event;

import ej.event.EventQueueNatives;

public class EventQueueMock {
    private static final int MAX_TYPE_ID = 127;
    private static final int INT_24_BITS = 0xFFFFFF;
    private static final int NO_ERR = 0;
    private static final int ERR_WRONG_ARGS = -1;
    private static final int ERR_FIFO_FULL = -2;

    private EventQueueMock() {
    }

    public static int offerEvent(int type, int data) {
        if (!EventQueueMock.checkArgumentValues(type, data)) {
            return -1;
        }
        if (EventQueueNatives.offerEvent(type, data)) {
            return 0;
        }
        return -2;
    }

    public static int offerExtendedEvent(int type, byte[] data, int dataLength) {
        if (!EventQueueMock.checkArgumentValues(type, dataLength)) {
            return -1;
        }
        if (EventQueueNatives.offerExtendedEvent(type, data, dataLength)) {
            return 0;
        }
        return -2;
    }

    private static boolean checkArgumentValues(int type, int data) {
        return type >= 0 && type <= 127 && (data & 0xFFFFFF) == data;
    }
}

