/*
 * Decompiled with CFR 0.152.
 */
package ej.event;

import com.is2t.hil.HIL;
import com.is2t.hil.NativeInterface;
import ej.sni.NativeIOException;
import java.io.IOException;
import java.nio.ByteOrder;

public class Event {
    private static final int TYPE_SHIFTER = 24;
    private static final int IS_EXTENDED_SHIFTER = 31;
    private static final int BYTE_SHIFTER = 8;
    private final boolean isExtended;
    private final int type;
    private final int data;
    private final byte[] extendedData;
    private final int extendedDataLength;
    private int offsetExtendedData;

    public Event(boolean isExtended, int type, int data, byte[] extendedData, int extendedDataLength) {
        this.isExtended = isExtended;
        this.type = type;
        this.data = data;
        if (extendedData != null) {
            this.extendedData = new byte[extendedData.length];
            System.arraycopy(extendedData, 0, this.extendedData, 0, extendedData.length);
        } else {
            this.extendedData = null;
        }
        this.extendedDataLength = extendedDataLength;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public int getMessage() {
        if (!this.isExtended) {
            return this.type << 24 | this.data;
        }
        return Integer.MIN_VALUE | this.type << 24 | this.extendedDataLength;
    }

    public void startRead() {
        this.offsetExtendedData = 0;
    }

    public byte readOneByte() throws IOException {
        if (this.available() < 1) {
            throw new NativeIOException(-1, "No byte remaining in the extended data.");
        }
        byte result = this.extendedData[this.offsetExtendedData];
        ++this.offsetExtendedData;
        return result;
    }

    public int readTwoBytes() throws IOException {
        if (this.available() < 2) {
            throw new NativeIOException(-1, "Less than 2 bytes remaining in the extended data.");
        }
        if (this.offsetExtendedData % 2 != 0) {
            ++this.offsetExtendedData;
        }
        byte byteOne = this.extendedData[this.offsetExtendedData];
        byte byteTwo = this.extendedData[this.offsetExtendedData + 1];
        this.offsetExtendedData += 2;
        int returnBytes = 0;
        returnBytes = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? ((byteTwo & 0xFF) << 8 | byteOne & 0xFF) & 0xFFFF : ((byteOne & 0xFF) << 8 | byteTwo & 0xFF) & 0xFFFF;
        return returnBytes;
    }

    public int readFourBytes() throws IOException {
        if (this.available() < 4) {
            throw new NativeIOException(-1, "Less than 4 bytes remaining in the extended data.");
        }
        int alignmentDifference = this.offsetExtendedData % 4;
        if (alignmentDifference != 0) {
            this.offsetExtendedData += 4 - alignmentDifference;
        }
        int returnValue = 0;
        int i = 0;
        while (i < 4) {
            returnValue = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? (this.extendedData[this.offsetExtendedData] & 0xFF) << i * 8 | returnValue : returnValue << 8 | this.extendedData[this.offsetExtendedData] & 0xFF;
            ++this.offsetExtendedData;
            ++i;
        }
        return returnValue;
    }

    public long readEightBytes() throws IOException {
        if (this.available() < 8) {
            throw new NativeIOException(-1, "Less than 8 bytes remaining in the extended data.");
        }
        int alignmentDifference = this.offsetExtendedData % 8;
        if (alignmentDifference != 0) {
            this.offsetExtendedData += 8 - alignmentDifference;
        }
        long returnValue = 0L;
        int i = 0;
        while (i < 8) {
            returnValue = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? (returnValue |= ((long)this.extendedData[this.offsetExtendedData] & 0xFFL) << i * 8) : returnValue << 8 | (long)this.extendedData[this.offsetExtendedData] & 0xFFL;
            ++this.offsetExtendedData;
            ++i;
        }
        return returnValue;
    }

    public int readFully(byte[] b) throws IOException {
        NativeInterface ni = HIL.getInstance();
        ni.refreshContent((Object)b);
        int availableBytes = this.available();
        if (availableBytes <= 0) {
            throw new NativeIOException(-1, "No bytes remaining in the extended event.");
        }
        if (availableBytes > b.length) {
            throw new NativeIOException(-1, "The buffer is too small to store the event data.");
        }
        System.arraycopy(this.extendedData, this.offsetExtendedData, b, 0, availableBytes);
        this.offsetExtendedData += availableBytes;
        ni.flushContent((Object)b);
        return availableBytes;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        NativeInterface ni = HIL.getInstance();
        ni.refreshContent((Object)b);
        int availableBytes = this.available();
        if (availableBytes < len) {
            throw new NativeIOException(-1, "Not enough bytes remaining in the extended event.");
        }
        if (this.offsetExtendedData + len > b.length) {
            throw new NativeIOException(-1, "The buffer is too small to store the event data.");
        }
        System.arraycopy(this.extendedData, this.offsetExtendedData, b, off, len);
        this.offsetExtendedData += len;
        ni.flushContent((Object)b);
        return len;
    }

    public int skipBytes(int n) {
        if (this.available() < n) {
            return -1;
        }
        int skipBytesCounter = 0;
        while (skipBytesCounter < n) {
            ++this.offsetExtendedData;
            ++skipBytesCounter;
        }
        return 0;
    }

    public int available() {
        return this.extendedDataLength - this.offsetExtendedData;
    }
}

