/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget.display;

import ej.fp.FrontPanel;
import ej.fp.Image;
import ej.fp.Widget;
import ej.fp.widget.display.brs.BufferRefreshStrategy;
import ej.fp.widget.display.buffer.DisplayBufferPolicy;
import ej.microui.Log;
import ej.microui.display.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DisplayBufferManager
implements Image {
    private static final int WHITE_OPAQUE = -1;
    private static final int BLACK_OPAQUE = -16777216;
    private static final int FULLY_TRANSPARENT = 0;
    private static final int MAX_COLOR_COMPONENT_VALUE = 255;
    private static final int ALPHA_SHIFT = 24;
    private static final int RED_SHIFT = 16;
    private static final int GREEN_SHIFT = 8;
    private static final int BLUE_SHIFT = 0;
    private static final int ALPHA_MASK = -16777216;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    private static final int LIGHT_COLOR_LIMIT = 127;
    private static final float BLUE_LIGHT_FACTOR = 0.114f;
    private static final float GREEN_LIGHT_FACTOR = 0.587f;
    private static final float RED_LIGHT_FACTOR = 0.299f;
    private static final int DEFAULT_DRAWN_COLOR = -16711936;
    private static final int DEFAULT_RESTORE_COLOR = -65281;
    private static final int DEFAULT_DIRTY_COLOR = 0x200000FF;
    private static final String DEBUG_DRAWN_COLOR = "ej.fp.brs.drawnColor";
    private static final String DEBUG_RESTORE_COLOR = "ej.fp.brs.restoredColor";
    private static final String DEBUG_DIRTY_COLOR = "ej.fp.brs.dirtyColor";
    private static final int DEBUG_COLOR_WIDTH = 8;
    private static final int DEBUG_COLOR_HEIGHT = 14;
    private final Widget displayWidget;
    private final DisplayBufferPolicy bufferPolicy;
    private final BufferRefreshStrategy refreshStrategy;
    private boolean hasFlushed;
    private final Object monitor;
    private final FlushThread flushThread;
    private int flushTimeMs;
    private int refreshRateTimeMs;
    private final Image debugBuffer;
    private boolean debugDrawn;
    private final int drawnColor;
    private final int drawnForeground;
    private final List<Rectangle> drawnRectangles;
    private boolean debugRestored;
    private final int restoredColor;
    private final int restoredForeground;
    private final List<Rectangle> restoredRectangles;
    private boolean debugDirty;
    private final int dirtyColor;
    private final Rectangle dirtyRectangle;
    private Image dirtyRectangleBuffer;

    public DisplayBufferManager(DisplayBufferPolicy bufferPolicy, BufferRefreshStrategy refreshStrategy, Widget displayWidget, int displayWidth, int displayHeight, int initialColor) {
        this.bufferPolicy = bufferPolicy;
        this.refreshStrategy = refreshStrategy;
        this.displayWidget = displayWidget;
        bufferPolicy.setDisplayProperties(displayWidget, displayWidth, displayHeight, initialColor);
        refreshStrategy.setBufferCount(bufferPolicy.getBufferCount());
        refreshStrategy.setDisplaySize(displayWidth, displayHeight);
        this.monitor = new Object();
        this.flushThread = new FlushThread();
        this.flushThread.setPriority(1);
        this.flushThread.start();
        this.debugBuffer = FrontPanel.getFrontPanel().newImage(displayWidth, displayHeight, initialColor, false);
        this.dirtyColor = DisplayBufferManager.getColorProperty(DEBUG_DIRTY_COLOR, 0x200000FF);
        this.debugDirty = DisplayBufferManager.isSetColorProperty(DEBUG_DIRTY_COLOR);
        this.dirtyRectangle = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.drawnColor = DisplayBufferManager.getColorProperty(DEBUG_DRAWN_COLOR, -16711936);
        this.debugDrawn = DisplayBufferManager.isSetColorProperty(DEBUG_DRAWN_COLOR);
        this.drawnForeground = DisplayBufferManager.getForegroundColor(this.drawnColor);
        this.drawnRectangles = new ArrayList<Rectangle>(0);
        this.restoredColor = DisplayBufferManager.getColorProperty(DEBUG_RESTORE_COLOR, -65281);
        this.debugRestored = DisplayBufferManager.isSetColorProperty(DEBUG_RESTORE_COLOR);
        this.restoredForeground = DisplayBufferManager.getForegroundColor(this.restoredColor);
        this.restoredRectangles = new ArrayList<Rectangle>(0);
    }

    public boolean isSetDebugDirty() {
        return this.debugDirty;
    }

    public void setDebugDirty(boolean debug) {
        this.debugDirty = debug;
    }

    public boolean isSetDebugDrawn() {
        return this.debugDrawn;
    }

    public void setDebugDrawn(boolean debug) {
        this.debugDrawn = debug;
    }

    public boolean isSetDebugRestored() {
        return this.debugRestored;
    }

    public void setDebugRestored(boolean debug) {
        this.debugRestored = debug;
    }

    public boolean isDoubleBuffered() {
        return this.bufferPolicy.isDoubleBuffered();
    }

    public Object getMonitor() {
        return this.monitor;
    }

    public Image getDisplayImage() {
        Image displayImage = this.bufferPolicy.getFrontBuffer();
        if (this.debugDrawn || this.debugRestored) {
            this.debugBuffer.drawImage(displayImage);
            displayImage = this.debugBuffer;
            this.addRestoredLayer(displayImage);
            this.addDrawLayer(displayImage);
        }
        return displayImage;
    }

    private void addDrawLayer(Image displayImage) {
        if (this.debugDrawn) {
            ArrayList<Rectangle> drawnRectangles = new ArrayList<Rectangle>(this.drawnRectangles);
            int drawnRectanglesLength = drawnRectangles.size();
            int i = 0;
            while (i < drawnRectanglesLength) {
                Rectangle rectangle = drawnRectangles.get(i);
                displayImage.drawRectangle(rectangle.getX1(), rectangle.getY1(), rectangle.getX2() - rectangle.getX1(), rectangle.getY2() - rectangle.getY1(), this.drawnColor);
                displayImage.drawLine(rectangle.getX1() + (rectangle.getX2() - rectangle.getX1()) / 2, rectangle.getY1(), rectangle.getX1() + (rectangle.getX2() - rectangle.getX1()) / 2, rectangle.getY2(), this.drawnColor);
                displayImage.drawLine(rectangle.getX1(), rectangle.getY1() + (rectangle.getY2() - rectangle.getY1()) / 2, rectangle.getX2(), rectangle.getY1() + (rectangle.getY2() - rectangle.getY1()) / 2, this.drawnColor);
                displayImage.drawString(Integer.toString(i), rectangle.getX1() + (rectangle.getX2() - rectangle.getX1()) / 2, rectangle.getY1() + (rectangle.getY2() - rectangle.getY1()) / 2 - 7, this.drawnForeground, this.drawnColor);
                ++i;
            }
        }
    }

    private void addRestoredLayer(Image displayImage) {
        if (this.debugRestored) {
            ArrayList<Rectangle> restoredRectangles = new ArrayList<Rectangle>(this.restoredRectangles);
            int restoredRectanglesLength = restoredRectangles.size();
            int i = 0;
            while (i < restoredRectanglesLength) {
                Rectangle rectangle = restoredRectangles.get(i);
                displayImage.drawRectangle(rectangle.getX1(), rectangle.getY1(), rectangle.getX2() - rectangle.getX1(), rectangle.getY2() - rectangle.getY1(), this.restoredColor);
                displayImage.drawLine(rectangle.getX1(), rectangle.getY1(), rectangle.getX2(), rectangle.getY2(), this.restoredColor);
                displayImage.drawLine(rectangle.getX2(), rectangle.getY1(), rectangle.getX1(), rectangle.getY2(), this.restoredColor);
                displayImage.drawString(Integer.toString(i), rectangle.getX1() + (rectangle.getX2() - rectangle.getX1()) / 2 - 8, rectangle.getY1() + (rectangle.getY2() - rectangle.getY1()) / 2 - 7, this.restoredForeground, this.restoredColor);
                ++i;
            }
        }
    }

    public Image getCurrentBackBuffer() {
        return this.bufferPolicy.getBackBuffer();
    }

    public void flush() {
        this.flushThread.wakeup();
    }

    public void waitFlush() {
        this.flushThread.waitFlush();
    }

    private void refresh() {
        this.refreshStrategy.refresh(this);
        this.hasFlushed = true;
    }

    private void initializeBoundingBox(Rectangle rectangle) {
        rectangle.setX1(Integer.MAX_VALUE);
        rectangle.setY1(Integer.MAX_VALUE);
        rectangle.setX2(Integer.MIN_VALUE);
        rectangle.setY2(Integer.MIN_VALUE);
    }

    public void flush(Rectangle[] rectangles) {
        this.drawnRectangles.clear();
        this.drawnRectangles.addAll(Arrays.asList(rectangles));
        this.bufferPolicy.flush(this, rectangles);
    }

    public void restore(Rectangle rectangle) {
        Log.recordEvent((int)57, (int[])new int[]{rectangle.getX1(), rectangle.getY1(), rectangle.getWidth(), rectangle.getHeight()});
        int x1 = rectangle.getX1();
        int y1 = rectangle.getY1();
        int width = rectangle.getWidth();
        int height = rectangle.getHeight();
        if (this.debugRestored) {
            int x2 = rectangle.getX2();
            int y2 = rectangle.getY2();
            this.restoredRectangles.add(new Rectangle(x1, y1, x2, y2));
            this.displayWidget.repaint();
        }
        this.bufferPolicy.getBackBuffer().drawImage(this.bufferPolicy.getFrontBuffer(), x1, y1, width, height, x1, y1, width, height);
    }

    public boolean isCleanBuffer() {
        return this.hasFlushed;
    }

    public void setFlushTime(int ms) {
        this.flushTimeMs = ms;
    }

    public void setRefreshTime(int ms) {
        this.refreshRateTimeMs = ms;
    }

    public void simulateFlushTime() {
        this.simulateWork(this.flushTimeMs);
    }

    private void simulateWork(double ms) {
        long currentTimeMillis = System.currentTimeMillis();
        while ((double)(System.currentTimeMillis() - currentTimeMillis) < ms) {
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newDrawingRegion(int x1, int y1, int x2, int y2, boolean drawingNow) {
        Rectangle rectangle = new Rectangle(x1, y1, x2, y2);
        Object object = this.monitor;
        synchronized (object) {
            if (this.hasFlushed) {
                this.restoredRectangles.clear();
            }
            this.hasFlushed = false;
            this.refreshStrategy.newDrawingRegion(this, rectangle, drawingNow);
        }
        this.updateDirtyRegion(rectangle);
    }

    private void updateDirtyRegion(Rectangle rectangle) {
        if (this.debugDirty) {
            Image currentBackBuffer = this.getCurrentBackBuffer();
            if (currentBackBuffer != this.dirtyRectangleBuffer) {
                this.dirtyRectangleBuffer = currentBackBuffer;
                this.initializeBoundingBox(this.dirtyRectangle);
            }
            if (this.updateDirtyRegionBoundingBox(rectangle)) {
                this.setDirtyRegion(rectangle);
            }
        }
    }

    private boolean updateDirtyRegionBoundingBox(Rectangle rectangle) {
        int x1 = rectangle.getX1();
        int x2 = rectangle.getX2();
        int y1 = rectangle.getY1();
        int y2 = rectangle.getY2();
        boolean result = false;
        Rectangle dirtyRectangle = this.dirtyRectangle;
        if (dirtyRectangle.getX1() > x1) {
            dirtyRectangle.setX1(x1);
            result = true;
        }
        if (dirtyRectangle.getY1() > y1) {
            dirtyRectangle.setY1(y1);
            result = true;
        }
        if (dirtyRectangle.getX2() < x2) {
            dirtyRectangle.setX2(x2);
            result = true;
        }
        if (dirtyRectangle.getY2() < y2) {
            dirtyRectangle.setY2(y2);
            result = true;
        }
        return result;
    }

    private void setDirtyRegion(Rectangle rectangle) {
        this.bufferPolicy.getBackBuffer().fillTransparentRectangle(rectangle.getX1(), rectangle.getY1(), rectangle.getWidth(), rectangle.getHeight(), this.dirtyColor);
    }

    public int getWidth() {
        return this.getCurrentBackBuffer().getWidth();
    }

    public int getHeight() {
        return this.getCurrentBackBuffer().getHeight();
    }

    public void setPixels(int[] pixels) {
        this.getCurrentBackBuffer().setPixels(pixels);
    }

    public void setPixels(int[] pixels, int offset, int scanLength, int x, int y, int width, int height) {
        this.getCurrentBackBuffer().setPixels(pixels, offset, scanLength, x, y, width, height);
    }

    public int readPixel(int x, int y) {
        return this.getCurrentBackBuffer().readPixel(x, y);
    }

    public void drawPixel(int x, int y, int color) {
        this.getCurrentBackBuffer().drawPixel(x, y, color);
    }

    public void fillRectangle(int x, int y, int width, int height, int color) {
        this.getCurrentBackBuffer().fillRectangle(x, y, width, height, color);
    }

    public Image getTransparentImage(byte alpha) {
        throw new IllegalStateException();
    }

    public Object getRAWImage() {
        return this.getCurrentBackBuffer().getRAWImage();
    }

    public void getPixels(int[] pixels) {
        this.getCurrentBackBuffer().getPixels(pixels);
    }

    public void getPixels(int[] pixels, int offset, int scanLength, int x, int y, int width, int height) {
        this.getCurrentBackBuffer().getPixels(pixels, offset, scanLength, x, y, width, height);
    }

    public void fillTransparentRectangle(int x, int y, int width, int height, int argbColor) {
        this.getCurrentBackBuffer().fillTransparentRectangle(x, y, width, height, argbColor);
    }

    public void fillOval(int x, int y, int width, int height, int color) {
        this.getCurrentBackBuffer().fillOval(x, y, width, height, color);
    }

    public void drawTransparentImage(Image image, byte alpha, int sx, int sy, int sWidth, int sHeight, int dx, int dy, int dWidth, int dHeight) {
        this.getCurrentBackBuffer().drawTransparentImage(image, alpha, sx, sy, sWidth, sHeight, dx, dy, dWidth, dHeight);
    }

    public void drawString(String s, int x, int y, int textColor, int backColor) {
        this.getCurrentBackBuffer().drawString(s, x, y, textColor, backColor);
    }

    public void drawRectangle(int x, int y, int width, int height, int color) {
        this.getCurrentBackBuffer().drawRectangle(x, y, width, height, color);
    }

    public void drawLine(int x1, int y1, int x2, int y2, int color) {
        this.getCurrentBackBuffer().drawLine(x1, y1, x2, y2, color);
    }

    public void drawImage(Image image, int sx, int sy, int sWidth, int sHeight, int dx, int dy, int dWidth, int dHeight) {
        this.getCurrentBackBuffer().drawImage(image, sx, sy, sWidth, sHeight, dx, dy, dWidth, dHeight);
    }

    public void setTransparentMode(boolean transparent) {
        this.getCurrentBackBuffer().setTransparentMode(transparent);
    }

    public void crop(Image mask) throws IllegalArgumentException {
        this.getCurrentBackBuffer().crop(mask);
    }

    public void dispose() {
        this.bufferPolicy.dispose();
        this.flushThread.dispose();
    }

    private static int getColorProperty(String name, int defaultValue) {
        return Long.getLong(name, defaultValue).intValue();
    }

    private static boolean isSetColorProperty(String name) {
        return Long.getLong(name) != null;
    }

    private static boolean isFullyTransparentColor(int color) {
        int alpha = (color & 0xFF000000) >>> 24;
        return alpha == 0;
    }

    private static int getForegroundColor(int color) {
        if (DisplayBufferManager.isFullyTransparentColor(color)) {
            return 0;
        }
        int red = (color & 0xFF0000) >>> 16;
        int green = (color & 0xFF00) >>> 8;
        int blue = (color & 0xFF) >>> 0;
        int light = (int)((float)red * 0.299f + (float)green * 0.587f + (float)blue * 0.114f);
        if (light > 127) {
            return -16777216;
        }
        return -1;
    }

    class FlushThread
    extends Thread {
        private final Object flushMonitor = new Object();
        private final Object waitFlushMonitor = new Object();
        private boolean wakedUp;
        private boolean isRunning = true;

        private FlushThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wakeup() {
            Object object = this.flushMonitor;
            synchronized (object) {
                this.wakedUp = true;
                this.flushMonitor.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitFlush() {
            Object object = this.waitFlushMonitor;
            synchronized (object) {
                while (this.isRunning) {
                    if (!this.wakedUp) {
                        return;
                    }
                    try {
                        this.waitFlushMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            this.isRunning = false;
            Object object = this.flushMonitor;
            synchronized (object) {
                this.flushMonitor.notifyAll();
            }
            object = this.waitFlushMonitor;
            synchronized (object) {
                this.waitFlushMonitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.isRunning) {
                Object object = this.flushMonitor;
                synchronized (object) {
                    double refreshRateTime;
                    while (this.isRunning && !this.wakedUp) {
                        try {
                            this.flushMonitor.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    if (this.isRunning) {
                        DisplayBufferManager.this.refresh();
                        this.wakedUp = false;
                        Object object2 = this.waitFlushMonitor;
                        synchronized (object2) {
                            this.waitFlushMonitor.notifyAll();
                        }
                    }
                    if ((refreshRateTime = (double)DisplayBufferManager.this.refreshRateTimeMs) > 0.0) {
                        DisplayBufferManager.this.simulateWork(refreshRateTime);
                    }
                }
            }
        }
    }
}

