/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.vm.support;

import com.is2t.tools.ArrayTools;
import ej.bon.Immortals;
import ej.sni.PoolOfImmortalByteBuffers;
import java.io.IOException;
import java.io.InputStream;

public class ExternalResourceInputStream
extends InputStream {
    private static final int EOF = -1;
    private static final int DEFAULT_NB_BUFFERS = 1;
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private static final String NB_BUFFERS_PROPERTY = "externalResources.buffers.number";
    private static final String BUFFER_SIZE_PROPERTY = "externalResources.buffers.size";
    private static PoolOfImmortalByteBuffers Buffers;
    private final int resourceID;
    private long markedPosition = 0L;
    private boolean closed;

    public ExternalResourceInputStream(int resID) {
        this.resourceID = resID;
        ExternalResourceInputStream.initBuffers();
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        int res = ExternalResourceInputStream.readByte(this.resourceID);
        if (res < -1) {
            this.throwIOException(res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        ArrayTools.checkBounds((byte[])b, (int)off, (int)len);
        if (!Immortals.isImmortal((Object)b)) {
            buffer = (byte[])ExternalResourceInputStream.Buffers.reserve();
            try {
                len = Math.min(len, buffer.length);
                nbRead = ExternalResourceInputStream.readBytes(this.resourceID, buffer, 0, len);
                if (nbRead <= 0) ** GOTO lbl16
                System.arraycopy(buffer, 0, b, off, nbRead);
            }
            finally {
                ExternalResourceInputStream.Buffers.release((Object)buffer);
            }
        } else {
            nbRead = ExternalResourceInputStream.readBytes(this.resourceID, b, off, len);
        }
lbl16:
        // 3 sources

        if (nbRead != -1 && nbRead <= 0 && len != 0) {
            this.throwIOException(nbRead);
        }
        return nbRead;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        int res = ExternalResourceInputStream.closeResource(this.resourceID);
        if (res < 0) {
            this.throwIOException(res);
        }
        this.closed = true;
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            return 0;
        }
        int available = ExternalResourceInputStream.available0(this.resourceID);
        if (available < 0) {
            this.throwIOException(available);
        }
        return available;
    }

    private static synchronized void initBuffers() {
        if (Buffers == null) {
            int nbBuffers = ExternalResourceInputStream.getStrictPositiveIntProperty(NB_BUFFERS_PROPERTY, 1);
            int bufferSize = ExternalResourceInputStream.getStrictPositiveIntProperty(BUFFER_SIZE_PROPERTY, 512);
            Buffers = new PoolOfImmortalByteBuffers(nbBuffers, bufferSize);
        }
    }

    private static int getStrictPositiveIntProperty(String property, int defaultValue) {
        String value = System.getProperty(property);
        if (value != null) {
            try {
                int ivalue = Integer.parseInt(property);
                if (ivalue <= 0) {
                    throw new IllegalArgumentException(property + "=" + ivalue);
                }
                return ivalue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (n < 0L) {
            return 0L;
        }
        if (n > Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
        }
        byte[] buffer = (byte[])Buffers.reserve();
        try {
            n = Math.min(n, (long)buffer.length);
            int res = ExternalResourceInputStream.readBytes(this.resourceID, buffer, 0, (int)n);
            if (res == -1) {
                long l = 0L;
                return l;
            }
            if (res < 0) {
                this.throwIOException(res);
            }
            long l = res;
            return l;
        }
        finally {
            Buffers.release((Object)buffer);
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.closed) {
            return;
        }
        long currentPosition = ExternalResourceInputStream.tell(this.resourceID);
        if (currentPosition < 0L) {
            return;
        }
        this.markedPosition = currentPosition;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        int res = ExternalResourceInputStream.seek(this.resourceID, this.markedPosition);
        if (res < 0) {
            this.throwIOException(res);
        }
    }

    private void throwIOException(int errorCode) throws IOException {
        throw new IOException(Integer.toString(errorCode));
    }

    static native int openResource(byte[] var0);

    static native int closeResource(int var0);

    static native int readByte(int var0);

    static native int readBytes(int var0, byte[] var1, int var2, int var3);

    static native int available0(int var0);

    static native int seek(int var0, long var1);

    static native long tell(int var0);
}

