/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.util.renderable;

import com.microej.wear.KernelServiceProvider;
import com.microej.wear.components.Navigator;
import com.microej.wear.components.Renderable;
import com.microej.wear.util.renderable.GestureDetector;
import ej.microui.display.GraphicsContext;
import ej.mwt.Desktop;
import ej.mwt.Widget;

public class RenderableDesktop
extends Desktop
implements Renderable {
    private final GestureDetector gestureDetector = new GestureDetector();

    public void onAttached() {
        this.setAttached();
    }

    public void onDetached() {
        this.setDetached();
    }

    public void render(GraphicsContext g) {
        if (this.isShown()) {
            super.render(g);
        } else {
            Widget widget = this.getWidget();
            if (widget != null) {
                this.renderWidget(g, widget);
            }
        }
    }

    public void showOnDisplay() {
        this.requestShow();
    }

    protected void onShown() {
        super.onShown();
        this.gestureDetector.reset();
    }

    public boolean handleEvent(int event) {
        Navigator navigator;
        Navigator.Gesture gesture = this.gestureDetector.processEvent(event);
        if (gesture != null && (navigator = KernelServiceProvider.getComponentService().getNavigator()).handleGesture(gesture)) {
            return true;
        }
        return super.handleEvent(event);
    }
}

