/*
 * Decompiled with CFR 0.152.
 */
package com.microej.wear.util.renderable;

import com.microej.wear.components.Navigator;
import ej.annotation.Nullable;
import ej.microui.event.Event;
import ej.microui.event.generator.Buttons;
import ej.microui.event.generator.Pointer;

public class GestureDetector {
    private static final int MIN_DRAG_DISTANCE = 100;
    private boolean pointerPressDisplayable;
    private boolean topButtonPressDisplayable;
    private boolean middleButtonPressDisplayable;
    private boolean bottomButtonPressDisplayable;
    private int pointerPressX;
    private int pointerPressY;
    private boolean pointerSwipeSent;

    public void reset() {
        this.pointerPressDisplayable = false;
        this.topButtonPressDisplayable = false;
        this.middleButtonPressDisplayable = false;
        this.bottomButtonPressDisplayable = false;
    }

    @Nullable
    public Navigator.Gesture processEvent(int event) {
        boolean pointerPressed = this.pointerPressDisplayable;
        boolean topButtonPressed = this.topButtonPressDisplayable;
        boolean middleButtonPressed = this.middleButtonPressDisplayable;
        boolean bottomButtonPressed = this.bottomButtonPressDisplayable;
        if (Event.getType((int)event) == 2) {
            Pointer pointer = (Pointer)Event.getGenerator((int)event);
            if (Buttons.isPressed((int)event)) {
                this.pointerPressDisplayable = true;
                this.pointerPressX = pointer.getX();
                this.pointerPressY = pointer.getY();
                this.pointerSwipeSent = false;
            } else if (Pointer.isDragged((int)event) && pointerPressed && !this.pointerSwipeSent) {
                int deltaX = pointer.getX() - this.pointerPressX;
                int deltaY = pointer.getY() - this.pointerPressY;
                Navigator.Gesture gesture = null;
                if (deltaX <= -100) {
                    gesture = Navigator.Gesture.SWIPE_LEFT;
                } else if (deltaX >= 100) {
                    gesture = Navigator.Gesture.SWIPE_RIGHT;
                } else if (deltaY <= -100) {
                    gesture = Navigator.Gesture.SWIPE_UP;
                } else if (deltaY >= 100) {
                    gesture = Navigator.Gesture.SWIPE_DOWN;
                }
                if (gesture != null) {
                    this.pointerSwipeSent = true;
                    return gesture;
                }
            } else if (Buttons.isLong((int)event) && pointerPressed) {
                return Navigator.Gesture.POINTER_LONG_PRESS;
            }
        }
        if (Event.getType((int)event) == 1) {
            int buttonId = Buttons.getButtonId((int)event);
            if (buttonId == 0) {
                if (Buttons.isPressed((int)event)) {
                    this.topButtonPressDisplayable = true;
                } else {
                    if (Buttons.isReleased((int)event) && topButtonPressed) {
                        return Navigator.Gesture.TOP_BUTTON_PRESS;
                    }
                    if (Buttons.isLong((int)event) && topButtonPressed) {
                        return Navigator.Gesture.TOP_BUTTON_LONG_PRESS;
                    }
                }
            } else if (buttonId == 1) {
                if (Buttons.isPressed((int)event)) {
                    this.middleButtonPressDisplayable = true;
                } else {
                    if (Buttons.isReleased((int)event) && middleButtonPressed) {
                        return Navigator.Gesture.MIDDLE_BUTTON_PRESS;
                    }
                    if (Buttons.isLong((int)event) && middleButtonPressed) {
                        return Navigator.Gesture.MIDDLE_BUTTON_LONG_PRESS;
                    }
                }
            } else if (buttonId == 2) {
                if (Buttons.isPressed((int)event)) {
                    this.bottomButtonPressDisplayable = true;
                } else {
                    if (Buttons.isReleased((int)event) && bottomButtonPressed) {
                        return Navigator.Gesture.BOTTOM_BUTTON_PRESS;
                    }
                    if (Buttons.isLong((int)event) && bottomButtonPressed) {
                        return Navigator.Gesture.BOTTOM_BUTTON_LONG_PRESS;
                    }
                }
            }
        }
        return null;
    }
}

