/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.std.ext;

import com.is2t.microej.workbench.CommonMessages;
import com.is2t.microej.workbench.ext.tools.Tools;
import com.is2t.microej.workbench.ext.widget.BrowseOption;
import com.is2t.microej.workbench.std.ext.JPFConstants;
import com.is2t.microej.workbench.std.ext.JPFExtensionAPI;
import com.is2t.microej.workbench.std.ext.JPFMessages;
import com.is2t.microej.workbench.std.launch.ext.ButtonBrowse;
import com.is2t.microej.workbench.std.launch.ext.ButtonRemove;
import com.is2t.microej.workbench.std.launch.ext.CategoryPage;
import com.is2t.microej.workbench.std.launch.ext.ComboOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.JPFExtensionRoot;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.ListButton;
import com.is2t.microej.workbench.std.launch.ext.OptionChangedListener;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.PathListOption;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.ComboMatchingIndexes;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;

public class JPFExtension
implements JPFExtensionAPI,
JPFConstants {
    public static final boolean OnLinux = System.getProperty("os.name").toLowerCase().indexOf("win") == -1;
    public static final String[] DEFAULT_BAUDRATES = new String[]{"9600", "38400", "57600", "115200"};
    public static final int DEFAULT_BAUDRATE_ID = 3;
    public ComboOption baudrate;
    public ComboOption pcBaudrate;

    public JPFExtensionRoot getExtensionTab() {
        Group grp = new Group(new PageContent[]{this.getAppGroup(), this.getPCConnectionGroup(DEFAULT_BAUDRATES, 3)}, 1);
        return Tools.createJPFExtensionRoot(new CategoryPage(JPFMessages.CategoryPCBoardConnection, grp));
    }

    public Group getAppGroup() {
        BrowseOption main = new BrowseOption((ILabel)new StringLabel(JPFMessages.LabelApplication), "application.file", CommonMessages.Message_Browse, JPFMessages.LabelApplication, new String[]{"*"});
        main.setDescription((Description)new XHTMLDescription(JPFMessages.DDApplication));
        ButtonBrowse addListButton = new ButtonBrowse(1, JPFMessages.LabelApplication, new String[]{"*"});
        addListButton.setButtonText("Add");
        ButtonRemove removeListButton = new ButtonRemove();
        removeListButton.setButtonText("Remove");
        ListButton[] listButtons = new ListButton[]{addListButton, removeListButton};
        PathListOption extras = new PathListOption((ILabel)new StringLabel(JPFMessages.LabelAdditionalApplications), "additional.application.files", listButtons, 4, ",");
        return new LabelGroup(JPFMessages.LabelApplicationGroup, new PageContent[]{main, extras}, 1);
    }

    private Group getPCConnectionGroup(String[] baudrateValues, int defaultValueId) {
        String[] labels = new String[]{JPFMessages.LabelProxyStartupUart, JPFMessages.LabelProxyStartupSocket, JPFMessages.LabelProxyStartupFile, JPFMessages.LabelProxyStartupConsole};
        String[] values = new String[]{"uart", "socket", "file", "console"};
        PageContent[] pageContents = new PageContent[4];
        ComboOption proxyConnectionType = new ComboOption((ILabel)new StringLabel(JPFMessages.LabelProxyConnectionType), "proxy.connection.connection.type", labels, values);
        proxyConnectionType.setInitialValue(3);
        proxyConnectionType.setDescription((Description)new XHTMLDescription(JPFMessages.DocumentDescriptionPCBoardConnectionType));
        pageContents[0] = new Group(new PageContent[]{proxyConnectionType}, 1);
        Group comm = this.buildPCCommConnection(baudrateValues, defaultValueId);
        comm.setEnableCondition((Expression)new ComboMatchingIndexes(proxyConnectionType, new int[1]));
        pageContents[1] = comm;
        Group socket = this.buildPCSocketConnection();
        socket.setEnableCondition((Expression)new ComboMatchingIndexes(proxyConnectionType, new int[]{1}));
        pageContents[2] = socket;
        Group file = this.buildPCFileConnection();
        file.setEnableCondition((Expression)new ComboMatchingIndexes(proxyConnectionType, new int[]{2}));
        pageContents[3] = file;
        LabelGroup group = new LabelGroup(JPFMessages.GroupPcConnection, pageContents, 1);
        group.setDescription((Description)new XHTMLDescription(JPFMessages.DocumentDescriptionGroupPcConnection));
        return group;
    }

    private Group buildPCCommConnection(String[] baudrateValues, int defaultValueId) {
        String defaultPort = OnLinux ? "/dev/ttyS0" : "COM0";
        TextFieldOption pcPort = new TextFieldOption((ILabel)new StringLabel(JPFMessages.LabelPcBoardComUartPcPort), "pcboardconnection.usart.pc.port");
        pcPort.setInitialValue(defaultPort);
        pcPort.setDescription((Description)new XHTMLDescription(JPFMessages.DocumentDescriptionPCBoardUartPort));
        pcPort.setOptionValidator(new OptionValidator(){

            public String getErrorMessage(PageContent option) {
                TextFieldOption t = (TextFieldOption)option;
                String value = t.getSelection().trim();
                if (value.length() == 0) {
                    return JPFMessages.ErrorPcBoardComUartPcPort;
                }
                return null;
            }
        });
        this.pcBaudrate = new ComboOption((ILabel)new StringLabel(JPFMessages.LabelPcBoardComUartPcBaudrate), "pcboardconnection.usart.pc.baudrate", baudrateValues);
        this.pcBaudrate.setInitialValue(defaultValueId);
        this.pcBaudrate.setDescription((Description)new XHTMLDescription(JPFMessages.DocumentDescriptionPCBoardUartBaudrate2));
        this.pcBaudrate.addOptionChangedListener(new OptionChangedListener(){

            public void changed() {
                if (JPFExtension.this.baudrate != null && !JPFExtension.this.baudrate.isEnabled()) {
                    JPFExtension.this.baudrate.combo.select(JPFExtension.this.pcBaudrate.combo.getSelectionIndex());
                }
            }
        });
        return new Group(new PageContent[]{pcPort, this.pcBaudrate}, 2);
    }

    private Group buildPCSocketConnection() {
        TextFieldOption socketPort = new TextFieldOption((ILabel)new StringLabel(JPFMessages.LabelPcBoardComSocketPort), "pcboardconnection.socket.port");
        socketPort.setInitialValue("5555");
        socketPort.setDescription((Description)new XHTMLDescription(JPFMessages.DocumentDescriptionPCBoardSocketPort));
        socketPort.setOptionValidator(new OptionValidator(){

            public String getErrorMessage(PageContent option) {
                TextFieldOption t = (TextFieldOption)option;
                String value = t.getSelection().trim();
                if (value.length() == 0) {
                    return JPFMessages.ErrorPcBoardComSocketPort;
                }
                return null;
            }
        });
        TextFieldOption socketAddress = new TextFieldOption((ILabel)new StringLabel(JPFMessages.LabelPcBoardComSocketAddress), "pcboardconnection.socket.address");
        socketAddress.setDescription((Description)new XHTMLDescription(JPFMessages.DocumentDescriptionPCBoardSocketAddress));
        socketAddress.setOptionValidator(new OptionValidator(){

            public String getErrorMessage(PageContent option) {
                TextFieldOption t = (TextFieldOption)option;
                String value = t.getSelection().trim();
                if (value.length() == 0) {
                    return JPFMessages.ErrorPcBoardComSocketAddress;
                }
                return null;
            }
        });
        return new Group(new PageContent[]{socketPort, socketAddress}, 2);
    }

    private Group buildPCFileConnection() {
        BrowseOption app = new BrowseOption((ILabel)new StringLabel(JPFMessages.LabelFileTrace), "pcboardconnection.file.path", CommonMessages.Message_Browse, JPFMessages.LabelFileTrace, new String[]{"*"});
        return new Group(new PageContent[]{app}, 2);
    }
}

