/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image;

import ej.microvg.image.ImageGenerator;
import ej.microvg.image.LinearGradient;
import ej.microvg.image.Path;
import ej.microvg.image.pathdata.TwoArraysPathData;
import java.awt.Color;
import java.nio.ByteBuffer;

public class OpenvgImageGenerator
implements ImageGenerator {
    protected static final byte CMD_CLOSE = 0;
    protected static final byte CMD_MOVE = 2;
    protected static final byte CMD_MOVE_REL = 3;
    protected static final byte CMD_LINE = 4;
    protected static final byte CMD_LINE_REL = 5;
    protected static final byte CMD_QUAD = 10;
    protected static final byte CMD_QUAD_REL = 11;
    protected static final byte CMD_CUBIC = 12;
    protected static final byte CMD_CUBIC_REL = 13;
    private final TwoArraysPathData pathData = new TwoArraysPathData();

    public OpenvgImageGenerator(ImageGenerator.Format format) {
    }

    @Override
    public int encodeCommand(ImageGenerator.Command command) {
        switch (command) {
            default: {
                return 0;
            }
            case COMMAND_MOVE: {
                return 2;
            }
            case COMMAND_MOVE_REL: {
                return 3;
            }
            case COMMAND_LINE: {
                return 4;
            }
            case COMMAND_LINE_REL: {
                return 5;
            }
            case COMMAND_QUAD: {
                return 10;
            }
            case COMMAND_QUAD_REL: {
                return 11;
            }
            case COMMAND_CUBIC: {
                return 12;
            }
            case COMMAND_CUBIC_REL: 
        }
        return 13;
    }

    @Override
    public int encodeColor(Color color, float opacity) {
        int newColor = 0;
        newColor |= color.getRed() << 16;
        newColor |= color.getGreen() << 8;
        newColor |= color.getBlue();
        return newColor |= (int)(opacity * 255.0f) << 24;
    }

    @Override
    public byte[] encodePath(Path path) {
        TwoArraysPathData pathData = this.pathData;
        path.encode(pathData);
        byte[] commands = pathData.getPathCommands();
        byte[] params = pathData.getPathParams();
        int commandLength = commands.length;
        int paramLength = params.length;
        int size = 20 + paramLength + commandLength;
        ByteBuffer buffer = this.newByteBuffer(size);
        buffer.putFloat((float)path.getMinX());
        buffer.putFloat((float)path.getMinY());
        buffer.putFloat((float)path.getMaxX());
        buffer.putFloat((float)path.getMaxY());
        buffer.putChar((char)commandLength);
        buffer.putChar((char)(paramLength / pathData.getFormat().getUnitSize()));
        buffer.put(params, 0, paramLength);
        buffer.put(commands, 0, commandLength);
        return buffer.array();
    }

    @Override
    public byte[] encodeGradient(LinearGradient gradient) {
        return new byte[0];
    }
}

