/*
 * Decompiled with CFR 0.152.
 */
package com.microej.vectorimage;

import com.microej.converter.vectorimage.Main;
import com.microej.tool.ui.generator.Image;
import com.microej.tool.ui.generator.ImageConverter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class VectorImageConverter
implements ImageConverter {
    private static final String VERBOSE = "0";

    public ImageConverter.OutputFile generate(Image image, File outputDir) throws IOException {
        try {
            File tempFile = new File(outputDir, String.valueOf(image.getRelativePath()) + "_temp");
            tempFile.deleteOnExit();
            Files.copy(image.getInputData(), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            ImageConverter.OutputFile out = this.generate(image, tempFile, outputDir);
            tempFile.delete();
            return out;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private ImageConverter.OutputFile generate(Image image, File source, File outputDir) {
        ImageConverter.OutputFile out = this.generateVectorImage(image, source, outputDir);
        if (out != null) {
            return out;
        }
        out = this.generateResourceFile(image, source, outputDir);
        if (out != null) {
            return out;
        }
        return null;
    }

    private ImageConverter.OutputFile generateVectorImage(Image image, File source, File outputDir) {
        String outputFormat;
        switch (this.getUserFormat(image)) {
            case "VG8": {
                outputFormat = "S8";
                break;
            }
            case "VG16": {
                outputFormat = "S16";
                break;
            }
            case "VG32": {
                outputFormat = "S32";
                break;
            }
            case "VGF": {
                outputFormat = "FP32";
                break;
            }
            default: {
                return null;
            }
        }
        final String imageOut = String.valueOf(image.getRelativePath()) + this.getOutputFileExtension();
        String identifier = image.getRelativePath().substring(1).replaceAll("/", ".");
        String gpu = System.getProperty("com.microej.microvg.implementation");
        gpu = gpu != null ? gpu.trim() : "vglite";
        String[] args = new String[]{"--input", source.getAbsolutePath(), "--format", outputFormat, "--folder", outputDir.getAbsolutePath(), "--raw", imageOut, "--gpu", gpu, "--verbose", VERBOSE, "--identifier", identifier, "--hierarchical"};
        if (Main.run(args)) {
            return new ImageConverter.OutputFile(){

                public ImageConverter.OutputFileType getType() {
                    return ImageConverter.OutputFileType.RESOURCE;
                }

                public String getRelativePath() {
                    return imageOut;
                }
            };
        }
        return null;
    }

    private ImageConverter.OutputFile generateResourceFile(Image image, File source, File outputDir) {
        String output;
        switch (this.getUserFormat(image)) {
            case "SVG": {
                output = "svg";
                break;
            }
            case "AVD": {
                output = "avd";
                break;
            }
            default: {
                return null;
            }
        }
        String relPath = image.getRelativePath();
        final String imageOut = String.valueOf(relPath.substring(0, relPath.lastIndexOf(46))) + "." + output;
        String[] args = new String[]{"--input", source.getAbsolutePath(), "--folder", outputDir.getAbsolutePath(), "--" + output, imageOut, "--verbose", VERBOSE};
        if (Main.run(args)) {
            return new ImageConverter.OutputFile(){

                public ImageConverter.OutputFileType getType() {
                    return ImageConverter.OutputFileType.RESOURCE;
                }

                public String getRelativePath() {
                    return imageOut;
                }
            };
        }
        return null;
    }

    private String getUserFormat(Image image) {
        return image.getOutputFormat().trim().toUpperCase();
    }

    public boolean generate(Image image, OutputStream stream) throws IOException {
        return false;
    }

    public String getOutputFileExtension() {
        return "_raw";
    }

    public String[] getListFileExtensions() {
        return new String[]{"vectorimages.list"};
    }
}

