/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vg;

import com.microej.converter.vectorimage.ShapeUtils;
import com.microej.converter.vectorimage.generator.AbstractGenerator;
import com.microej.converter.vectorimage.vg.VGAnimation;
import com.microej.converter.vectorimage.vg.VGPathSegment;
import java.util.List;

public class VGTranslateXYAnimation
extends VGAnimation {
    private final String pathData;
    private final List<VGPathSegment> segments;
    private final List<VGPathSegment> linearSegments;

    public VGTranslateXYAnimation(int duration, int startOffset, int keepDuration, String interpolatorPathData, String pathData) {
        super(duration, startOffset, keepDuration, interpolatorPathData);
        this.pathData = pathData;
        this.segments = VGPathSegment.pathData2Segments(pathData);
        String flatPath = ShapeUtils.getFlattenedPathString(ShapeUtils.getPathShape(pathData), null, 0.01f);
        this.linearSegments = VGPathSegment.pathData2Segments(flatPath);
        this.setSegmentsBounds();
    }

    public String getTranslationPathData() {
        String linearPathDataInterpolator = "";
        for (VGPathSegment element : this.linearSegments) {
            linearPathDataInterpolator = String.valueOf(linearPathDataInterpolator) + " " + element;
        }
        return linearPathDataInterpolator;
    }

    public List<VGPathSegment> getTranslationPathSegments() {
        return this.linearSegments;
    }

    @Override
    public boolean isNull() {
        return this.segments.size() == 0 || 0.0f == this.getPathLength();
    }

    private float getPathLength() {
        float length = 0.0f;
        for (VGPathSegment segment : this.segments) {
            length += segment.getLength();
        }
        return length;
    }

    private void setSegmentsBounds() {
        float length = this.getPathLength();
        float origin = 0.0f;
        float end = 0.0f;
        for (VGPathSegment linearSegment : this.linearSegments) {
            float segmentLength = linearSegment.getLength();
            end = length == 0.0f ? origin + segmentLength : origin + segmentLength / length;
            linearSegment.setEnd(end);
            origin = end;
        }
        this.linearSegments.get(this.linearSegments.size() - 1).setEnd(1.0f);
    }

    @Override
    public String toString() {
        String logStr = "TranslateXY animation -";
        logStr = String.valueOf(logStr) + " PathData:" + this.pathData + " - " + super.toString();
        return logStr;
    }

    @Override
    public void print(AbstractGenerator printerBase) {
        printerBase.print(this);
    }
}

