/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vg;

import com.microej.converter.vectorimage.generator.AbstractGenerator;
import com.microej.converter.vectorimage.vg.VGAnimation;

public class VGTranslateAnimation
extends VGAnimation {
    private float translationX;
    private float translationY;
    private float startX;
    private float startY;

    public VGTranslateAnimation(int duration, int startOffset, int keepDuration, String interpolatorPathData, float translationX, float translationY, float startX, float startY) {
        super(duration, startOffset, keepDuration, interpolatorPathData);
        this.translationX = translationX;
        this.translationY = translationY;
        this.startX = startX;
        this.startY = startY;
    }

    public float getTranslationX() {
        return this.translationX;
    }

    public float getTranslationY() {
        return this.translationY;
    }

    public float getStartX() {
        return this.startX;
    }

    public float getStartY() {
        return this.startY;
    }

    @Override
    public boolean merge(VGAnimation anim) {
        VGTranslateAnimation animation = (VGTranslateAnimation)anim;
        if (this.duration != animation.duration || this.startOffset != animation.startOffset || this.keepDuration != animation.keepDuration) {
            return false;
        }
        this.translationX += animation.translationX;
        this.translationY += animation.translationY;
        this.startX += animation.startX;
        this.startY += animation.startY;
        return true;
    }

    @Override
    public boolean isNull() {
        return this.translationX == 0.0f && this.translationY == 0.0f && this.startX == 0.0f && this.startY == 0.0f;
    }

    @Override
    public String toString() {
        String logStr = "Translate animation -";
        logStr = String.valueOf(logStr) + " Sx: " + this.startX + " Sy: " + this.startY + " Tx: " + this.translationX + " Ty: " + this.translationY + " - " + super.toString();
        return logStr;
    }

    @Override
    public void print(AbstractGenerator printerBase) {
        printerBase.print(this);
    }
}

