/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vg;

import com.microej.converter.vectorimage.generator.AbstractGenerator;
import com.microej.converter.vectorimage.vg.VGAnimation;

public class VGScaleAnimation
extends VGAnimation {
    private static float ZERO_SCALE = 1.0E-6f;
    float scaleXFrom;
    float scaleXTo;
    float scaleYFrom;
    float scaleYTo;
    float pivotX;
    float pivotY;

    public VGScaleAnimation(int duration, int startOffset, int keepDuration, String interpolatorPathData, float scaleXFrom, float scaleXTo, float scaleYFrom, float scaleYTo, float pivotX, float pivotY) {
        super(duration, startOffset, keepDuration, interpolatorPathData);
        this.scaleXFrom = scaleXFrom;
        this.scaleXTo = scaleXTo;
        this.scaleYFrom = scaleYFrom;
        this.scaleYTo = scaleYTo;
        if (0.0f == this.scaleXFrom) {
            this.scaleXFrom = ZERO_SCALE;
        }
        if (0.0f == this.scaleYFrom) {
            this.scaleYFrom = ZERO_SCALE;
        }
        if (0.0f == this.scaleXTo) {
            this.scaleXTo = ZERO_SCALE;
        }
        if (0.0f == this.scaleYTo) {
            this.scaleYTo = ZERO_SCALE;
        }
        this.pivotX = pivotX;
        this.pivotY = pivotY;
    }

    public float getScaleXFrom() {
        return this.scaleXFrom;
    }

    public float getScaleXTo() {
        return this.scaleXTo;
    }

    public float getScaleYFrom() {
        return this.scaleYFrom;
    }

    public float getScaleYTo() {
        return this.scaleYTo;
    }

    public float getPivotX() {
        return this.pivotX;
    }

    public float getPivotY() {
        return this.pivotY;
    }

    @Override
    public boolean merge(VGAnimation anim) {
        VGScaleAnimation animation = (VGScaleAnimation)anim;
        if (this.duration != animation.duration || this.startOffset != animation.startOffset || this.keepDuration != animation.keepDuration) {
            return false;
        }
        this.scaleXFrom *= animation.scaleXFrom;
        this.scaleXTo *= animation.scaleXTo;
        this.scaleYFrom *= animation.scaleYFrom;
        this.scaleYTo *= animation.scaleYTo;
        return true;
    }

    @Override
    public boolean isNull() {
        return this.scaleXFrom == 1.0f && this.scaleXTo == 1.0f && this.scaleYFrom == 1.0f && this.scaleYTo == 1.0f;
    }

    @Override
    public String toString() {
        String logStr = "Scale animation -";
        logStr = String.valueOf(logStr) + " FromX: " + this.scaleXFrom + " FromY: " + this.scaleYFrom + " ToX: " + this.scaleXTo + " ToY: " + this.scaleYTo + " pivotX: " + this.pivotX + " pivotY: " + this.pivotY + " - " + super.toString();
        return logStr;
    }

    @Override
    public void print(AbstractGenerator printerBase) {
        printerBase.print(this);
    }
}

