/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vg;

import com.microej.converter.vectorimage.ShapeUtils;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;

public class VGPathSegment {
    private static final int UNSIGNED_SHORT_MAX_VALUE = 65535;
    private static final int SHORT_MIN_VALUE = 32768;
    private static final float FLATNESS = 0.01f;
    private String type = "";
    private float x0 = 0.0f;
    private float x1 = 0.0f;
    private float x2 = 0.0f;
    private float x3 = 0.0f;
    private float y0 = 0.0f;
    private float y1 = 0.0f;
    private float y2 = 0.0f;
    private float y3 = 0.0f;
    private float length = 0.0f;
    private float end = 0.0f;

    VGPathSegment(String type, float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        this.type = type;
        this.x0 = x0;
        this.x1 = x1;
        this.x2 = x2;
        this.x3 = x3;
        this.y0 = y0;
        this.y1 = y1;
        this.y2 = y2;
        this.y3 = y3;
        this.updateLength();
    }

    public String getType() {
        return this.type;
    }

    public float getLength() {
        return this.length;
    }

    public void setEnd(float end) {
        this.end = end;
    }

    public short getEndShort() {
        return (short)(this.end * 65535.0f - 32768.0f);
    }

    public float getX0() {
        return this.x0;
    }

    public float getX1() {
        return this.x1;
    }

    public float getX2() {
        return this.x2;
    }

    public float getX3() {
        return this.x3;
    }

    public float getY0() {
        return this.y0;
    }

    public float getY1() {
        return this.y1;
    }

    public float getY2() {
        return this.y2;
    }

    public float getY3() {
        return this.y3;
    }

    private void updateLength() {
        if (this.type.equals("L")) {
            this.length = this.segLength(this.x0, this.y0, this.x1, this.y1);
        } else if (this.type.equals("C")) {
            Path2D.Float path = new Path2D.Float();
            ((Path2D)path).moveTo(this.x0, this.y0);
            ((Path2D)path).curveTo(this.x1, this.y1, this.x2, this.y2, this.x3, this.y3);
            String flatPath = ShapeUtils.getFlattenedPathString(path, null, 0.01f);
            ArrayList<VGPathSegment> linearSegments = VGPathSegment.pathData2Segments(flatPath);
            this.length = 0.0f;
            for (VGPathSegment segment : linearSegments) {
                this.length += segment.getLength();
            }
        }
    }

    public static ArrayList<VGPathSegment> pathData2Segments(String pathData) {
        Shape interpolator = ShapeUtils.getPathShape(pathData);
        ArrayList<VGPathSegment> segments = new ArrayList<VGPathSegment>();
        PathIterator i = interpolator.getPathIterator(new AffineTransform());
        double[] coords = new double[6];
        float originX = 0.0f;
        float originY = 0.0f;
        while (!i.isDone()) {
            int k = i.currentSegment(coords);
            if (k != 4) {
                if (k == 3) {
                    VGPathSegment cubicSegment = new VGPathSegment("C", originX, originY, (float)coords[0], (float)coords[1], (float)coords[2], (float)coords[3], (float)coords[4], (float)coords[5]);
                    segments.add(cubicSegment);
                    cubicSegment.setEnd((float)coords[4]);
                    originX = (float)coords[4];
                    originY = (float)coords[5];
                } else if (k != 2) {
                    if (k == 1) {
                        VGPathSegment linearSegment = new VGPathSegment("L", originX, originY, (float)coords[0], (float)coords[1], 0.0f, 0.0f, 0.0f, 0.0f);
                        linearSegment.setEnd((float)coords[0]);
                        originX = (float)coords[0];
                        originY = (float)coords[1];
                        segments.add(linearSegment);
                    } else if (k == 0) {
                        originX = (float)coords[0];
                        originY = (float)coords[1];
                    } else {
                        throw new RuntimeException("unexpected segment type (" + k + ")");
                    }
                }
            }
            i.next();
        }
        return segments;
    }

    private float segLength(float x0, float y0, float x1, float y1) {
        return (float)Math.sqrt(Math.pow(x1 - x0, 2.0) + Math.pow(y1 - y0, 2.0));
    }

    public String toString() {
        if (this.type.equals("L")) {
            Path2D.Float path = new Path2D.Float();
            ((Path2D)path).moveTo(this.x0, this.y0);
            ((Path2D)path).lineTo(this.x1, this.y1);
            return ShapeUtils.getPathString(path);
        }
        if (this.type.equals("C")) {
            Path2D.Float path = new Path2D.Float();
            ((Path2D)path).moveTo(this.x0, this.y0);
            ((Path2D)path).curveTo(this.x1, this.y1, this.x2, this.y2, this.x3, this.y3);
            return ShapeUtils.getPathString(path);
        }
        return "";
    }
}

