/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vg;

import com.microej.converter.vectorimage.Logger;
import com.microej.converter.vectorimage.ShapeUtils;
import com.microej.converter.vectorimage.generator.AbstractGenerator;
import com.microej.converter.vectorimage.vg.VGAnimation;
import java.awt.Shape;

public class VGPathDataAnimation
extends VGAnimation {
    private final String valueFrom;
    private final String valueTo;

    public VGPathDataAnimation(int duration, int startOffset, int keepDuration, String interpolatorPathData, String valueFrom, String valueTo) {
        super(duration, startOffset, keepDuration, interpolatorPathData);
        this.valueFrom = valueFrom;
        this.valueTo = valueTo;
        Shape sFrom = ShapeUtils.getPathShape(this.valueFrom);
        Shape sTo = ShapeUtils.getPathShape(this.valueTo);
        if (!ShapeUtils.getPathCmdString(sFrom).equals(ShapeUtils.getPathCmdString(sTo))) {
            Logger.logErrString("PathDataAnimation path commands differ: " + ShapeUtils.getPathCmdString(sFrom) + " != " + ShapeUtils.getPathCmdString(sTo));
        }
    }

    public String getValueFrom() {
        return this.valueFrom;
    }

    public String getValueTo() {
        return this.valueTo;
    }

    @Override
    public String toString() {
        String logStr = "PathData animation -";
        logStr = String.valueOf(logStr) + " valueFrom: " + this.valueFrom + " valueTo: " + this.valueTo + " - " + super.toString();
        return logStr;
    }

    @Override
    public void print(AbstractGenerator printerBase) {
        printerBase.print(this);
    }
}

