/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vg;

import com.microej.converter.vectorimage.ShapeUtils;
import com.microej.converter.vectorimage.generator.AbstractGenerator;
import com.microej.converter.vectorimage.vg.VGAnimation;
import com.microej.converter.vectorimage.vg.VGAnimations;
import com.microej.converter.vectorimage.vg.VGElement;
import com.microej.converter.vectorimage.vg.VGStyle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class VGPath
extends VGElement {
    private final String pathData;
    private final VGStyle style;
    private final VGAnimations colorAnimations;
    private final VGAnimations alphaAnimations;
    private final VGAnimations pathDataAnimations;

    public VGPath(String name, String pathData, VGStyle style, VGAnimations animations, VGAnimations colorAnimations, VGAnimations alphaAnimations, VGAnimations pathDataAnimations) {
        super(name);
        this.pathData = pathData;
        this.style = style;
        this.animations = animations.toArray();
        this.colorAnimations = colorAnimations;
        this.alphaAnimations = alphaAnimations;
        this.pathDataAnimations = pathDataAnimations;
    }

    public String getPathData() {
        return this.pathData;
    }

    public VGStyle getStyle() {
        return this.style;
    }

    public VGAnimation[] getAnimations() {
        return this.animations;
    }

    public VGAnimations getColorAnimations() {
        return this.colorAnimations;
    }

    public VGAnimations getAlphaAnimations() {
        return this.alphaAnimations;
    }

    public VGAnimations getPathDataAnimations() {
        return this.pathDataAnimations;
    }

    @Override
    public Shape getShape(AffineTransform parentAt) {
        Shape s = ShapeUtils.getPathShape(this.pathData);
        if (parentAt != null) {
            s = parentAt.createTransformedShape(s);
        }
        return s;
    }

    public boolean isVisible() {
        return this.style.getGradient() != null || 0.0f != this.style.getOpacity() && !this.style.getNoFill() || !this.alphaAnimations.animations.isEmpty();
    }

    public String toString() {
        String str = "";
        String indent = "";
        int i = 0;
        while (i < this.level) {
            indent = String.valueOf(indent) + "  ";
            ++i;
        }
        str = String.valueOf(str) + indent + "Path " + this.name + " level:" + this.level + "\n";
        str = this.pathData.length() > 1000 ? String.valueOf(str) + indent + "Path:" + this.pathData.substring(0, 1000) + " ...\n" : String.valueOf(str) + indent + "Path:" + this.pathData + "\n";
        str = String.valueOf(str) + indent + "Style:" + this.style + "\n";
        if (!this.colorAnimations.animations.isEmpty()) {
            String animStr = "";
            for (VGAnimation vgAnimation : this.colorAnimations.animations) {
                animStr = String.valueOf(animStr) + vgAnimation;
            }
            str = String.valueOf(str) + indent + "    colorAnimations:" + animStr + "\n";
        }
        if (!this.alphaAnimations.animations.isEmpty()) {
            String animStr = "";
            for (VGAnimation vgAnimation : this.alphaAnimations.animations) {
                animStr = String.valueOf(animStr) + vgAnimation;
            }
            str = String.valueOf(str) + indent + "    alphaAnimations:" + animStr + "\n";
        }
        if (!this.pathDataAnimations.animations.isEmpty()) {
            String animStr = "";
            for (VGAnimation vgAnimation : this.pathDataAnimations.animations) {
                animStr = String.valueOf(animStr) + vgAnimation;
            }
            str = String.valueOf(str) + indent + "    pathDataAnimations:" + animStr + "\n";
        }
        return str;
    }

    public boolean hasAnimations() {
        return !this.colorAnimations.animations.isEmpty() || !this.alphaAnimations.animations.isEmpty() || !this.pathDataAnimations.animations.isEmpty();
    }

    @Override
    public void print(AbstractGenerator printer) throws Exception {
        printer.print(this);
    }
}

