/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vg;

import com.microej.converter.vectorimage.generator.AbstractGenerator;
import com.microej.converter.vectorimage.vg.VGGroup;
import java.awt.geom.AffineTransform;

public class VGGroupTransform
extends VGGroup {
    AffineTransform at = null;
    float scaleX;
    float scaleY;
    final float translateX;
    final float translateY;
    final float rotation;
    final float pivotX;
    final float pivotY;

    public VGGroupTransform(String name, float scaleX, float scaleY, float translateX, float translateY, float rotation, float pivotX, float pivotY) {
        super(name);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.translateX = translateX;
        this.translateY = translateY;
        this.rotation = rotation;
        this.pivotX = pivotX;
        this.pivotY = pivotY;
        this.at = new AffineTransform();
        this.at.translate(translateX, translateY);
        this.at.translate(pivotX, pivotY);
        this.at.rotate(Math.toRadians(rotation));
        this.at.scale(scaleX, scaleY);
        this.at.translate(-pivotX, -pivotY);
    }

    @Override
    public void print(AbstractGenerator printer) throws Exception {
        printer.print(this);
    }

    @Override
    public boolean canRemove() {
        return super.canRemove() && this.at.isIdentity();
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
        this.at.scale(scaleX, 1.0);
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
        this.at.scale(1.0, scaleY);
    }

    public AffineTransform getTransformation() {
        return this.at;
    }

    @Override
    protected void concatenateTranformation(AffineTransform at) {
        at.concatenate(this.at);
    }

    public boolean hasTransformations() {
        return !this.at.isIdentity();
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float getTranslateX() {
        return this.translateX;
    }

    public float getTranslateY() {
        return this.translateY;
    }

    public float getPivotX() {
        return this.pivotX;
    }

    public float getPivotY() {
        return this.pivotY;
    }

    public float getRotation() {
        return this.rotation;
    }

    @Override
    public String toString() {
        String str = "";
        String indent = "";
        int i = 0;
        while (i < this.level) {
            indent = String.valueOf(indent) + "  ";
            ++i;
        }
        str = String.valueOf(str) + indent + "Group " + this.name + " level:" + this.level + "\n";
        str = String.valueOf(str) + indent + "    Transformation:" + this.at + "\n";
        for (Object child : this.children) {
            str = String.valueOf(str) + child;
        }
        return str;
    }
}

