/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vg;

import com.microej.converter.vectorimage.ShapeUtils;
import com.microej.converter.vectorimage.generator.AbstractGenerator;
import com.microej.converter.vectorimage.vg.VGElement;
import com.microej.converter.vectorimage.vg.VGPath;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;

public class VGGroup
extends VGElement {
    protected final ArrayList<VGElement> children = new ArrayList();

    public VGGroup(String name) {
        super(name);
    }

    public void addChild(VGElement child) {
        this.children.add(child);
        child.setLevel(this.level + 1);
    }

    public boolean canRemove() {
        for (VGElement child : this.children) {
            if (!(child instanceof VGPath)) continue;
            return false;
        }
        return true;
    }

    public void reduce() {
        ArrayList<VGElement> toAdd = new ArrayList<VGElement>();
        for (VGElement child : this.children) {
            if (child instanceof VGGroup) {
                ((VGGroup)child).reduce();
                if (((VGGroup)child).canRemove()) {
                    for (VGElement subchild : ((VGGroup)child).getChildren()) {
                        toAdd.add(subchild);
                    }
                } else {
                    toAdd.add(child);
                }
            }
            if (!(child instanceof VGPath) || !((VGPath)child).isVisible()) continue;
            toAdd.add(child);
        }
        this.children.removeAll(this.children);
        for (VGElement child : toAdd) {
            this.addChild(child);
        }
    }

    public void setChildrenNames(String name) {
        int nameId = 0;
        for (VGElement child : this.children) {
            if (child instanceof VGGroup) {
                child.setName("Group" + name + "_" + nameId);
                ((VGGroup)child).setChildrenNames(String.valueOf(name) + "_" + nameId);
            } else {
                child.setName("Path" + name + "_" + nameId);
            }
            ++nameId;
        }
    }

    public boolean hasOverlappingPaths(AffineTransform parentAt) {
        Shape currentShape = null;
        Shape childShape = null;
        AffineTransform localAt = new AffineTransform();
        if (parentAt != null) {
            localAt.concatenate(parentAt);
        }
        this.concatenateTranformation(localAt);
        for (VGElement child : this.children) {
            if (child instanceof VGGroup && ((VGGroup)child).hasOverlappingPaths(localAt)) {
                return true;
            }
            childShape = child.getShape(localAt);
            if (ShapeUtils.overlapping(currentShape, childShape)) {
                return true;
            }
            currentShape = ShapeUtils.union(currentShape, childShape);
        }
        return false;
    }

    @Override
    public Shape getShape(AffineTransform parentAt) {
        AffineTransform localAt = new AffineTransform();
        if (parentAt != null) {
            localAt.concatenate(parentAt);
        }
        this.concatenateTranformation(localAt);
        Shape currentShape = null;
        for (VGElement child : this.children) {
            currentShape = ShapeUtils.union(currentShape, child.getShape(localAt));
        }
        return currentShape;
    }

    protected void concatenateTranformation(AffineTransform at) {
    }

    public String toString() {
        String str = "";
        String indent = "";
        int i = 0;
        while (i < this.level) {
            indent = String.valueOf(indent) + "  ";
            ++i;
        }
        str = String.valueOf(str) + indent + "Group " + this.name + " level:" + this.level + "\n";
        for (VGElement child : this.children) {
            str = String.valueOf(str) + child;
        }
        return str;
    }

    public Iterable<VGElement> getChildren() {
        return this.children;
    }

    @Override
    public void print(AbstractGenerator printer) throws Exception {
        printer.print(this);
    }
}

