/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vg;

import com.microej.converter.vectorimage.vg.VGColor;
import com.microej.converter.vectorimage.vg.VGGradientStop;
import ej.microvg.image.LinearGradient;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class VGGradient
implements LinearGradient {
    private final Point2D origin;
    private final Point2D end;
    private final Point2D originTransformed;
    private final Point2D endTransformed;
    private LinearGradient.LinearGradientStop[] stops;
    public final AffineTransform transform;
    private GradientUnit gradientUnits = GradientUnit.USERSPACEONUSE;

    public VGGradient() {
        this.origin = new Point2D.Float(0.0f, 0.0f);
        this.end = new Point2D.Float(0.0f, 0.0f);
        this.originTransformed = new Point2D.Float(0.0f, 0.0f);
        this.endTransformed = new Point2D.Float(0.0f, 0.0f);
        this.stops = VGGradient.fallbackStopsList(new LinearGradient.LinearGradientStop[0]);
        this.transform = new AffineTransform();
    }

    @Override
    public float getXStart() {
        return (float)this.originTransformed.getX();
    }

    public void setX1(float x1) {
        this.origin.setLocation(x1, this.origin.getY());
        this.applyTransform();
    }

    @Override
    public float getYStart() {
        return (float)this.originTransformed.getY();
    }

    public void setY1(float y1) {
        this.origin.setLocation(this.origin.getX(), y1);
        this.applyTransform();
    }

    @Override
    public float getXEnd() {
        return (float)this.endTransformed.getX();
    }

    public void setX2(float x2) {
        this.end.setLocation(x2, this.end.getY());
        this.applyTransform();
    }

    @Override
    public float getYEnd() {
        return (float)this.endTransformed.getY();
    }

    public void setY2(float y2) {
        this.end.setLocation(this.end.getX(), y2);
        this.applyTransform();
    }

    @Override
    public LinearGradient.LinearGradientStop[] getStops() {
        return this.stops;
    }

    public void setStops(LinearGradient.LinearGradientStop[] stops) {
        this.stops = VGGradient.fallbackStopsList(stops);
    }

    public GradientUnit getGradientUnits() {
        return this.gradientUnits;
    }

    public void setGradientUnits(GradientUnit gradientUnits) {
        this.gradientUnits = gradientUnits;
    }

    public void setTransform(AffineTransform transform) {
        this.transform.setTransform(transform);
        this.applyTransform();
    }

    public void addTransform(AffineTransform transform) {
        AffineTransform at = new AffineTransform();
        at.concatenate(transform);
        at.concatenate(this.transform);
        this.transform.setTransform(at);
        this.applyTransform();
    }

    public void applyTransform() {
        this.transform.transform(this.origin, this.originTransformed);
        this.transform.transform(this.end, this.endTransformed);
    }

    public String toString() {
        String str = "";
        str = String.valueOf(str) + " x1:" + this.originTransformed.getX();
        str = String.valueOf(str) + " Y1:" + this.originTransformed.getY();
        str = String.valueOf(str) + " x2:" + this.endTransformed.getX();
        str = String.valueOf(str) + " Y2:" + this.endTransformed.getY();
        int i = 0;
        while (i < this.getStops().length) {
            str = String.valueOf(str) + " stop" + i + ": " + this.getStops()[i];
            ++i;
        }
        return str;
    }

    private static LinearGradient.LinearGradientStop[] fallbackStopsList(LinearGradient.LinearGradientStop[] stops) {
        switch (stops.length) {
            case 0: {
                return VGGradient.fallbackStopsList(Color.BLACK, 0.0f);
            }
            case 1: {
                LinearGradient.LinearGradientStop origin = stops[0];
                return VGGradient.fallbackStopsList(origin.getColor(), origin.getOpacity());
            }
        }
        return stops;
    }

    private static LinearGradient.LinearGradientStop[] fallbackStopsList(Color color, float opacity) {
        VGGradientStop stop0 = new VGGradientStop(new VGColor(color));
        stop0.setOpacity(opacity);
        stop0.setOffset(0.0f);
        VGGradientStop stop1 = new VGGradientStop(new VGColor(color));
        stop1.setOpacity(opacity);
        stop1.setOffset(1.0f);
        return new LinearGradient.LinearGradientStop[]{stop0, stop1};
    }

    public static enum GradientUnit {
        UNKNOWN,
        USERSPACEONUSE,
        OBJECTBOUNDINGBOX;

    }
}

