/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vg;

import com.microej.converter.vectorimage.vg.VGColorKeyword;
import java.awt.Color;
import java.lang.reflect.Field;

public class VGColor {
    private final Color color;

    private static VGColor create(String colorString) {
        Color color = new Color(0);
        if ('#' != colorString.charAt(0)) {
            if (!colorString.startsWith("rgb")) {
                try {
                    Field field = VGColorKeyword.class.getField(colorString.toUpperCase());
                    color = (Color)field.get(null);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unexpected color format: " + colorString);
                }
            } else {
                String[] rgb = (colorString = colorString.replace("rgb", "").replace(" ", "").replace("(", "").replace(")", "")).split(",");
                if (rgb[0].contains("%") || rgb[1].contains("%") || rgb[2].contains("%")) {
                    int[] rgbInt = new int[3];
                    int i = 0;
                    while (i < 3) {
                        rgbInt[i] = (int)(Float.parseFloat(rgb[i].replace("%", "")) * 255.0f / 100.0f);
                        ++i;
                    }
                    color = new Color(rgbInt[0], rgbInt[1], rgbInt[2]);
                } else {
                    color = new Color(Integer.parseInt(rgb[0], 10), Integer.parseInt(rgb[1], 10), Integer.parseInt(rgb[2], 10));
                }
            }
        } else if (4 == colorString.length()) {
            String newColorString = String.valueOf(colorString.substring(0, 2)) + colorString.substring(1, 2) + colorString.substring(2, 3) + colorString.substring(2, 3) + colorString.substring(3, 4) + colorString.substring(3, 4);
            color = new Color(Integer.parseInt(newColorString.substring(1), 16));
        } else if (9 == colorString.length()) {
            int alpha = Integer.parseInt(colorString.substring(1, 3), 16);
            int red = Integer.parseInt(colorString.substring(3, 5), 16);
            int green = Integer.parseInt(colorString.substring(5, 7), 16);
            int blue = Integer.parseInt(colorString.substring(7, 9), 16);
            color = new Color(red, green, blue, alpha);
        } else {
            color = new Color(Integer.parseInt(colorString.substring(1), 16));
        }
        return new VGColor(color);
    }

    public VGColor(Color color) {
        this.color = color;
    }

    public static VGColor createColor(String colorString) {
        if (colorString == null || colorString.isEmpty() || colorString.equals("none")) {
            return null;
        }
        return VGColor.create(colorString);
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return this.getColor().toString();
    }
}

