/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vg;

import com.microej.converter.vectorimage.ShapeUtils;
import com.microej.converter.vectorimage.generator.AbstractGenerator;
import com.microej.converter.vectorimage.vg.VGPathSegment;
import java.awt.Shape;
import java.util.List;

public abstract class VGAnimation {
    protected final int duration;
    protected final int startOffset;
    protected final int keepDuration;
    protected final String interpolatorPathData;
    private final List<VGPathSegment> linearSegments;

    public VGAnimation(int duration, int startOffset, int keepDuration, String interpolatorPathData) {
        this.duration = duration;
        this.startOffset = startOffset;
        this.keepDuration = keepDuration;
        this.interpolatorPathData = interpolatorPathData;
        Shape s = ShapeUtils.getPathShape(interpolatorPathData);
        this.linearSegments = VGPathSegment.pathData2Segments(ShapeUtils.getFlattenedPathString(s, null, 0.01f));
        for (VGPathSegment seg : this.linearSegments) {
            seg.setEnd(seg.getX1());
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getKeepDuration() {
        return this.keepDuration;
    }

    public String getInterpolatorPathData() {
        String linearPathDataInterpolator = "";
        for (VGPathSegment element : this.linearSegments) {
            linearPathDataInterpolator = String.valueOf(linearPathDataInterpolator) + " " + element;
        }
        return linearPathDataInterpolator;
    }

    public List<VGPathSegment> getInterpolatorSegments() {
        return this.linearSegments;
    }

    public boolean isNull() {
        return false;
    }

    public boolean merge(VGAnimation anim2) {
        return false;
    }

    public String toString() {
        return " duration: " + this.duration + " - startOffset: " + this.startOffset + " - keepDuration: " + this.keepDuration;
    }

    public abstract void print(AbstractGenerator var1);
}

