/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vd;

import com.microej.converter.vectorimage.Logger;
import com.microej.converter.vectorimage.XmlUtils;
import com.microej.converter.vectorimage.vd.VectorDrawableGroup;
import com.microej.converter.vectorimage.vg.VGGroupMaster;
import java.awt.geom.AffineTransform;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VectorDrawableVector {
    private static final String VD_ATTRIBUTE_WIDTH = "android:width";
    private static final String VD_ATTRIBUTE_HEIGHT = "android:height";
    private static final String VD_ATTRIBUTE_VIEWPORT_WIDTH = "android:viewportWidth";
    private static final String VD_ATTRIBUTE_VIEWPORT_HEIGHT = "android:viewportHeight";
    private static final String VD_ATTRIBUTE_ALPHA = "android:alpha";
    final String name = "";
    float width = 0.0f;
    float height = 0.0f;
    float alpha = 1.0f;
    float viewportWidth = 0.0f;
    float viewportHeight = 0.0f;
    VectorDrawableGroup topGroup;
    AffineTransform at;

    public VectorDrawableVector(Element root) {
        String[] unsupported_units;
        Element vector = this.getVectorChild(root);
        String widthStr = "";
        String heightStr = "";
        this.viewportWidth = XmlUtils.getAttribute(vector, this.viewportWidth, VD_ATTRIBUTE_VIEWPORT_WIDTH);
        this.viewportHeight = XmlUtils.getAttribute(vector, this.viewportHeight, VD_ATTRIBUTE_VIEWPORT_HEIGHT);
        widthStr = XmlUtils.getAttribute(vector, widthStr, VD_ATTRIBUTE_WIDTH);
        heightStr = XmlUtils.getAttribute(vector, heightStr, VD_ATTRIBUTE_HEIGHT);
        this.alpha = XmlUtils.getAttribute(vector, this.alpha, VD_ATTRIBUTE_ALPHA);
        String[] stringArray = unsupported_units = new String[]{"dp"};
        int n = unsupported_units.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            if (widthStr.endsWith(unit) || heightStr.endsWith(unit)) {
                widthStr = widthStr.replace(unit, "");
                heightStr = heightStr.replace(unit, "");
            }
            ++n2;
        }
        this.width = Float.parseFloat(widthStr);
        this.height = Float.parseFloat(heightStr);
        this.at = new AffineTransform();
        this.at.scale(this.width / this.viewportWidth, this.height / this.viewportHeight);
        this.topGroup = new VectorDrawableGroup(vector);
    }

    public void computePaths(VGGroupMaster parent) {
        parent.setScaleX((float)this.at.getScaleX());
        parent.setScaleY((float)this.at.getScaleY());
        this.topGroup.computePaths(parent, 0, this.alpha, this.at, null);
        if (1.0f != this.alpha && parent.hasOverlappingPaths(new AffineTransform())) {
            Logger.logErrString("Global android:alpha with overlapping path leads to unexpected drawings.\nBeware having fillColor and strokeColor on same path gives overlapping paths.");
        }
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    private Element getVectorChild(Element root) {
        if ("vector" == root.getNodeName()) {
            return root;
        }
        NodeList list = root.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Element element;
            Element vector;
            Node node = list.item(i);
            if (1 == node.getNodeType() && node != null && (vector = this.getVectorChild(element = (Element)node)) != null) {
                return vector;
            }
            ++i;
        }
        return null;
    }
}

