/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vd;

import com.microej.converter.vectorimage.Logger;
import com.microej.converter.vectorimage.ShapeUtils;
import com.microej.converter.vectorimage.XmlUtils;
import com.microej.converter.vectorimage.vd.VectorDrawableGradient;
import com.microej.converter.vectorimage.vd.VectorDrawableGroupAnimations;
import com.microej.converter.vectorimage.vd.VectorDrawableParser;
import com.microej.converter.vectorimage.vg.VGAnimations;
import com.microej.converter.vectorimage.vg.VGColor;
import com.microej.converter.vectorimage.vg.VGGradient;
import com.microej.converter.vectorimage.vg.VGGroup;
import com.microej.converter.vectorimage.vg.VGPath;
import com.microej.converter.vectorimage.vg.VGPathDataAnimation;
import com.microej.converter.vectorimage.vg.VGStyle;
import com.microej.converter.vectorimage.vg.VGUtils;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VectorDrawablePath {
    private static final String VD_ATTRIBUTE_NAME = "android:name";
    private static final String VD_ATTRIBUTE_PATHDATA = "android:pathData";
    private static final String VD_ATTRIBUTE_FILLCOLOR = "android:fillColor";
    private static final String VD_ATTRIBUTE_STROKECOLOR = "android:strokeColor";
    private static final String VD_ATTRIBUTE_STROKEWIDTH = "android:strokeWidth";
    private static final String VD_ATTRIBUTE_STROKEALPHA = "android:strokeAlpha";
    private static final String VD_ATTRIBUTE_FILLALPHA = "android:fillAlpha";
    private static final String VD_ATTRIBUTE_TRIMPATHSTART = "android:trimPathStart";
    private static final String VD_ATTRIBUTE_TRIMPATHEND = "android:trimPathEnd";
    private static final String VD_ATTRIBUTE_TRIMPATHOFFSET = "android:trimPathOffset";
    private static final String VD_ATTRIBUTE_STROKELINECAP = "android:strokeLineCap";
    private static final String VD_ATTRIBUTE_STROKELINEJOIN = "android:strokeLineJoin";
    private static final String VD_ATTRIBUTE_STROKEMITERLIMIT = "android:strokeMiterLimit";
    private static final String VD_ATTRIBUTE_FILLTYPE = "android:fillType";
    private static final String VD_ATTRIBUTE_FILLTYPE_NONZERO = "nonZero";
    private static final String VD_ATTRIBUTE_FILLTYPE_EVENODD = "evenOdd";
    private static final String VD_ATTRIBUTE_STROKELINECAP_ROUND = "round";
    private static final String VD_ATTRIBUTE_STROKELINECAP_SQUARE = "square";
    private static final String VD_ATTRIBUTE_STROKELINECAP_BUTT = "butt";
    private static final String VD_ATTRIBUTE_STROKELINEJOIN_ROUND = "round";
    private static final String VD_ATTRIBUTE_STROKELINEJOIN_BEVEL = "bevel";
    private static final String VD_ATTRIBUTE_STROKELINEJOIN_MITER = "miter";
    private static final String VD_ELEMENT_AAPT = "aapt:attr";
    private static final String VD_ELEMENT_GRADIENT = "gradient";
    private final String name;
    private final String pathData;
    private final String fillColor;
    private final String strokeColor;
    private String strokeWidth;
    private final float strokeWidthFloat;
    private final float strokeAlpha;
    private final float fillAlpha;
    private final String strokeLineCap;
    private final String strokeLineJoin;
    private final float strokeMiterLimit;
    private final String fillType;
    private final HashMap<String, VectorDrawableGradient> gradients = new HashMap();

    public VectorDrawablePath(Element path) {
        this.name = XmlUtils.getAttribute(path, "Noname", VD_ATTRIBUTE_NAME);
        this.pathData = XmlUtils.getAttribute(path, "", VD_ATTRIBUTE_PATHDATA);
        this.fillColor = XmlUtils.getAttribute(path, "", VD_ATTRIBUTE_FILLCOLOR);
        this.strokeColor = XmlUtils.getAttribute(path, "", VD_ATTRIBUTE_STROKECOLOR);
        this.strokeWidth = XmlUtils.getAttribute(path, "0", VD_ATTRIBUTE_STROKEWIDTH);
        this.strokeAlpha = XmlUtils.getAttribute(path, 1.0f, VD_ATTRIBUTE_STROKEALPHA);
        this.fillAlpha = XmlUtils.getAttribute(path, 1.0f, VD_ATTRIBUTE_FILLALPHA);
        this.strokeLineCap = XmlUtils.getAttribute(path, VD_ATTRIBUTE_STROKELINECAP_BUTT, VD_ATTRIBUTE_STROKELINECAP);
        this.strokeLineJoin = XmlUtils.getAttribute(path, VD_ATTRIBUTE_STROKELINEJOIN_MITER, VD_ATTRIBUTE_STROKELINEJOIN);
        this.strokeMiterLimit = XmlUtils.getAttribute(path, 4.0f, VD_ATTRIBUTE_STROKEMITERLIMIT);
        this.fillType = XmlUtils.getAttribute(path, VD_ATTRIBUTE_FILLTYPE_NONZERO, VD_ATTRIBUTE_FILLTYPE);
        if (this.strokeWidth.contains("%")) {
            this.strokeWidth = this.strokeWidth.replace("%", "");
            Logger.logWarnString("% is not supported in strokewidth, will be replace by " + this.strokeWidth);
        }
        this.strokeWidthFloat = Float.parseFloat(this.strokeWidth);
        NodeList list = path.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Element element;
            String elementName;
            Node node = list.item(i);
            if (1 == node.getNodeType() && node != null && VD_ELEMENT_AAPT.equals(elementName = (element = (Element)node).getNodeName())) {
                String aaptName = XmlUtils.getAttribute(element, "", "name");
                NodeList aaptList = element.getChildNodes();
                int j = 0;
                while (j < aaptList.getLength()) {
                    Element aaptElement;
                    String aaptElementName;
                    Node aaptNode = aaptList.item(j);
                    if (1 == aaptNode.getNodeType() && aaptNode != null && VD_ELEMENT_GRADIENT.equals(aaptElementName = (aaptElement = (Element)aaptNode).getNodeName())) {
                        VectorDrawableGradient gradient = VectorDrawableGradient.parse(aaptElement);
                        this.gradients.put(aaptName, gradient);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public int computePaths(VGGroup parent, int pathId, float alpha, AffineTransform at, VectorDrawableGroupAnimations animations, Shape parentClip) {
        VGStyle style = new VGStyle();
        Shape shape = ShapeUtils.getPathShape(this.pathData);
        if (parentClip != null) {
            shape = ShapeUtils.clipShape(shape, parentClip);
        }
        VectorDrawableGroupAnimations localAnimations = new VectorDrawableGroupAnimations();
        localAnimations.add(animations);
        VGAnimations vgAnimations = new VGAnimations();
        int i = 0;
        while (i < localAnimations.size()) {
            vgAnimations.add(localAnimations.get(i).toVG());
            ++i;
        }
        vgAnimations.reduce();
        if ("" != this.fillColor || this.gradients.containsKey(VD_ATTRIBUTE_FILLCOLOR)) {
            VGColor svgFill;
            String pathStringTransformed = ShapeUtils.getPathString(shape);
            String idString = "Path" + pathId++;
            if ("" != this.fillColor && (svgFill = VGColor.createColor(this.fillColor)) != null) {
                style.setFill(svgFill);
                style.setNoFill(false);
                style.setOpacity(this.fillAlpha);
                if (this.fillType.equals(VD_ATTRIBUTE_FILLTYPE_NONZERO)) {
                    style.setFillRule(false);
                } else if (this.fillType.equals(VD_ATTRIBUTE_FILLTYPE_EVENODD)) {
                    style.setFillRule(true);
                } else {
                    Logger.logWarnString("Incorrect fillType:" + this.fillType + " replaced by NONZERO");
                    style.setFillRule(false);
                }
                float opacity = 1.0f;
                if (9 == this.fillColor.length()) {
                    opacity = (float)VectorDrawableParser.getOpacity(this.fillColor) / 256.0f;
                }
                style.setOpacity(alpha * opacity);
            }
            if (this.gradients.containsKey(VD_ATTRIBUTE_FILLCOLOR)) {
                VectorDrawableGradient vdGradient = this.gradients.get(VD_ATTRIBUTE_FILLCOLOR);
                VGGradient vgGradient = vdGradient.toVG(alpha);
                style.setGradient(vgGradient);
            }
            VGAnimations colorAnimations = new VGAnimations();
            VGAnimations alphaAnimations = new VGAnimations();
            VGAnimations pathDataAnimations = new VGAnimations();
            if (VectorDrawableParser.animations.getAnimationsMap().containsKey(this.name)) {
                localAnimations = VectorDrawableParser.animations.getAnimationsMap().get(this.name);
                int i2 = 0;
                while (i2 < localAnimations.size()) {
                    if (localAnimations.get(i2).getPropertyName().equals("fillColor")) {
                        colorAnimations.add(localAnimations.get(i2).toVG());
                    }
                    if (localAnimations.get(i2).getPropertyName().equals("fillAlpha")) {
                        alphaAnimations.add(localAnimations.get(i2).toVG());
                    }
                    if (localAnimations.get(i2).getPropertyName().equals("pathData")) {
                        pathDataAnimations.add(localAnimations.get(i2).toVG());
                    }
                    ++i2;
                }
            }
            VGPath vgPath = VGUtils.createVGPath(idString, pathStringTransformed, style, vgAnimations, colorAnimations, alphaAnimations, pathDataAnimations);
            parent.addChild(vgPath);
        }
        if (0.0f != this.strokeWidthFloat && ("" != this.strokeColor || this.gradients.containsKey(VD_ATTRIBUTE_STROKECOLOR))) {
            BasicStroke stroke = this.getStroke();
            Shape strokeShape = stroke.createStrokedShape(shape);
            String pathStringTransformed = ShapeUtils.getPathString(strokeShape);
            String idString = "PathStroke" + pathId++;
            VGStyle strokeStyle = new VGStyle();
            VGColor svgFill = VGColor.createColor(this.strokeColor);
            if ("" != this.strokeColor && svgFill != null) {
                strokeStyle.setFill(svgFill);
                strokeStyle.setNoFill(false);
                strokeStyle.setOpacity(this.strokeAlpha);
                float opacity = 1.0f;
                if (9 == this.strokeColor.length()) {
                    opacity = (float)VectorDrawableParser.getOpacity(this.strokeColor) / 256.0f;
                }
                strokeStyle.setOpacity(alpha * opacity);
            }
            if (this.gradients.containsKey(VD_ATTRIBUTE_STROKECOLOR)) {
                VectorDrawableGradient vdGradient = this.gradients.get(VD_ATTRIBUTE_STROKECOLOR);
                VGGradient vgGradient = vdGradient.toVG(alpha);
                strokeStyle.setGradient(vgGradient);
            }
            VGAnimations colorAnimations = new VGAnimations();
            VGAnimations alphaAnimations = new VGAnimations();
            if (VectorDrawableParser.animations.getAnimationsMap().containsKey(this.name)) {
                localAnimations = VectorDrawableParser.animations.getAnimationsMap().get(this.name);
                int i3 = 0;
                while (i3 < localAnimations.size()) {
                    if (localAnimations.get(i3).getPropertyName().equals("strokeColor")) {
                        colorAnimations.add(localAnimations.get(i3).toVG());
                    }
                    if (localAnimations.get(i3).getPropertyName().equals("strokeAlpha")) {
                        alphaAnimations.add(localAnimations.get(i3).toVG());
                    }
                    if (localAnimations.get(i3).getPropertyName().equals("pathData")) {
                        String errString = "PathData animation is not supported for path with stroke\n";
                        VGPathDataAnimation pathDataAnimation = (VGPathDataAnimation)localAnimations.get(i3).toVG();
                        String strokeFromPath = ShapeUtils.getPathString(stroke.createStrokedShape(ShapeUtils.getPathShape(pathDataAnimation.getValueFrom())));
                        String strokeToPath = ShapeUtils.getPathString(stroke.createStrokedShape(ShapeUtils.getPathShape(pathDataAnimation.getValueTo())));
                        errString = String.valueOf(errString) + "From stroke path:" + strokeFromPath + "\n";
                        errString = String.valueOf(errString) + "To stroke path:" + strokeToPath + "\n";
                        Logger.logErrString(errString);
                    }
                    ++i3;
                }
            }
            VGPath vgPath = VGUtils.createVGPath(idString, pathStringTransformed, strokeStyle, vgAnimations, colorAnimations, alphaAnimations, new VGAnimations());
            parent.addChild(vgPath);
        }
        return pathId;
    }

    private BasicStroke getStroke() {
        int strokeLinecapInt = 0;
        switch (this.strokeLineCap) {
            case "round": {
                strokeLinecapInt = 1;
                break;
            }
            case "square": {
                strokeLinecapInt = 2;
                break;
            }
            case "butt": {
                strokeLinecapInt = 0;
                break;
            }
            default: {
                Logger.logErrString("Invalid linecap:" + this.strokeLineCap);
            }
        }
        int strokeLinejoinInt = 0;
        switch (this.strokeLineJoin) {
            case "round": {
                strokeLinejoinInt = 1;
                break;
            }
            case "bevel": {
                strokeLinejoinInt = 2;
                break;
            }
            case "miter": {
                strokeLinejoinInt = 0;
                break;
            }
            default: {
                Logger.logErrString("Invalid linejoin:" + this.strokeLineJoin + " replaced by " + VD_ATTRIBUTE_STROKELINEJOIN_MITER);
            }
        }
        float[] strokeDash = null;
        float strokeDashphase = 0.0f;
        return new BasicStroke(this.strokeWidthFloat, strokeLinecapInt, strokeLinejoinInt, this.strokeMiterLimit, strokeDash, strokeDashphase);
    }
}

