/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vd;

import com.microej.converter.vectorimage.FileParser;
import com.microej.converter.vectorimage.vd.VectorDrawableAnimations;
import com.microej.converter.vectorimage.vd.VectorDrawableVector;
import com.microej.converter.vectorimage.vg.VGGroupMaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class VectorDrawableParser
extends FileParser {
    VectorDrawableVector vector;
    static VectorDrawableAnimations animations;

    public VectorDrawableParser(String inFilePath) throws FileNotFoundException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        try {
            File inputFile = new File(inFilePath);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputFile);
            Element root = doc.getDocumentElement();
            animations = new VectorDrawableAnimations(root);
            this.vector = new VectorDrawableVector(root);
            this.topGroup = new VGGroupMaster();
            this.vector.computePaths(this.topGroup);
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new IOException("Can not parse " + inFilePath);
        }
    }

    @Override
    public VGGroupMaster getVGTopGroup() {
        return this.topGroup;
    }

    @Override
    public float getSVGWidth() {
        return this.vector.getWidth();
    }

    @Override
    public float getSVGHeight() {
        return this.vector.getHeight();
    }

    public static int getOpacity(String color) {
        return Integer.decode("0x" + color.substring(1, 3));
    }
}

