/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vd;

import com.microej.converter.vectorimage.ShapeUtils;
import com.microej.converter.vectorimage.XmlUtils;
import com.microej.converter.vectorimage.vg.VGAlphaAnimation;
import com.microej.converter.vectorimage.vg.VGAnimation;
import com.microej.converter.vectorimage.vg.VGColor;
import com.microej.converter.vectorimage.vg.VGColorAnimation;
import com.microej.converter.vectorimage.vg.VGPathDataAnimation;
import com.microej.converter.vectorimage.vg.VGRotateAnimation;
import com.microej.converter.vectorimage.vg.VGScaleAnimation;
import com.microej.converter.vectorimage.vg.VGTranslateAnimation;
import com.microej.converter.vectorimage.vg.VGTranslateXYAnimation;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VectorDrawableObjectAnimator
implements Comparable<Object> {
    private static final String VD_ATTRIBUTE_PROPERTYNAME = "android:propertyName";
    private static final String VD_ATTRIBUTE_STARTOFFSET = "android:startOffset";
    private static final String VD_ATTRIBUTE_DURATION = "android:duration";
    private static final String VD_ATTRIBUTE_VALUEFROM = "android:valueFrom";
    private static final String VD_ATTRIBUTE_VALUETO = "android:valueTo";
    private static final String VD_ATTRIBUTE_VALUETYPE = "android:valueType";
    private static final String VD_ATTRIBUTE_INTERPOLATOR = "android:interpolator";
    private static final String VD_ATTRIBUTE_PATHDATA = "android:pathData";
    private static final String VD_ELEMENT_AAPT = "aapt:attr";
    private static final String VD_ELEMENT_PATHINTERPOLATOR = "pathInterpolator";
    public static final String VD_ATTRIBUTE_PROPERTYNAME_SCALEX = "scaleX";
    public static final String VD_ATTRIBUTE_PROPERTYNAME_SCALEY = "scaleY";
    public static final String VD_ATTRIBUTE_PROPERTYNAME_TRANSLATEX = "translateX";
    public static final String VD_ATTRIBUTE_PROPERTYNAME_TRANSLATEY = "translateY";
    public static final String VD_ATTRIBUTE_PROPERTYNAME_TRANSLATEXY = "translateXY";
    public static final String VD_ATTRIBUTE_PROPERTYNAME_ROTATION = "rotation";
    public static final String VD_ATTRIBUTE_PROPERTYNAME_FILLCOLOR = "fillColor";
    public static final String VD_ATTRIBUTE_PROPERTYNAME_STROKECOLOR = "strokeColor";
    public static final String VD_ATTRIBUTE_PROPERTYNAME_FILLALPHA = "fillAlpha";
    public static final String VD_ATTRIBUTE_PROPERTYNAME_STROKEALPHA = "strokeAlpha";
    public static final String VD_ATTRIBUTE_PROPERTYNAME_PATHDATA = "pathData";
    private final String propertyname;
    private final float startoffset;
    private final float duration;
    private float keepDuration;
    private String valuefrom;
    private String valueto;
    private String interpolator;
    private String interpolatorPathData = "M 0,0 L 1,1";
    private String pathData;
    private float pivotX = 0.0f;
    private float pivotY = 0.0f;

    public VectorDrawableObjectAnimator(Element element) {
        this.propertyname = XmlUtils.getAttribute(element, "", VD_ATTRIBUTE_PROPERTYNAME);
        this.startoffset = XmlUtils.getAttribute(element, 0.0f, VD_ATTRIBUTE_STARTOFFSET);
        this.duration = XmlUtils.getAttribute(element, 0.0f, VD_ATTRIBUTE_DURATION);
        this.valuefrom = XmlUtils.getAttribute(element, "", VD_ATTRIBUTE_VALUEFROM);
        this.valueto = XmlUtils.getAttribute(element, "", VD_ATTRIBUTE_VALUETO);
        this.interpolator = XmlUtils.getAttribute(element, "", VD_ATTRIBUTE_INTERPOLATOR);
        this.pathData = XmlUtils.getAttribute(element, "", VD_ATTRIBUTE_PATHDATA);
        this.keepDuration = 0.0f;
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            String aaptName;
            Element el;
            String elementName;
            Node node = list.item(i);
            if (1 == node.getNodeType() && node != null && VD_ELEMENT_AAPT.equals(elementName = (el = (Element)node).getNodeName()) && VD_ATTRIBUTE_INTERPOLATOR.equals(aaptName = XmlUtils.getAttribute(el, "", "name"))) {
                NodeList aaptList = el.getChildNodes();
                int j = 0;
                while (j < aaptList.getLength()) {
                    Element aaptElement;
                    String aaptElementName;
                    Node aaptNode = aaptList.item(j);
                    if (1 == aaptNode.getNodeType() && aaptNode != null && VD_ELEMENT_PATHINTERPOLATOR.equals(aaptElementName = (aaptElement = (Element)aaptNode).getNodeName())) {
                        this.interpolatorPathData = XmlUtils.getAttribute(aaptElement, this.pathData, VD_ATTRIBUTE_PATHDATA);
                    }
                    ++j;
                }
            }
            ++i;
        }
        HashMap<String, String> interpolators = new HashMap<String, String>();
        interpolators.put("accelerate_cubic", "M 0 0 C 0.74 -0.088 0.954 0.921 1 1");
        interpolators.put("accelerate_decelerate", "M 0 0 C 0.378 0.016 0.624 0.99 1 1");
        interpolators.put("accelerate_quad", "M 0 0 C 0.601 0.019 0.992 1.024 1 1");
        interpolators.put("anticipate", "M 0 0 C 0.112 0.013 0.381 -0.186 0.537 -0.115 C 0.763 -0.011 0.9 0.503 1 1");
        interpolators.put("anticipate_overshoot", "M 0 0 C 0.198 -0.035 0.328 -0.461 0.5 0.5 C 0.661 1.501 0.839 0.998 1 1");
        interpolators.put("bounce", "M 0 0 C 0.155 -0.001 0.25 0.662 0.318 0.984 C 0.49 0.42 0.607 0.843 0.66 1 C 0.747 0.83 0.809 0.908 0.86 0.999 C 0.896 0.951 0.938 0.918 1 1");
        interpolators.put("cycle", "M 0 0 C 0.034 0.161 0.118 0.961 0.25 1 C 0.418 1.039 0.569 -1.007 0.751 -1.001 C 0.792 -0.986 0.863 -0.945 1 0");
        interpolators.put("decelerate_cubic", "M 0 0 C 0.121 0.403 0.296 0.672 0.397 0.78 C 0.59 1.003 0.807 0.994 1 1");
        interpolators.put("decelerate_quad", "M 0 0 C 0.031 0.067 0.463 0.996 1 1");
        interpolators.put("decelerate_quint", "M 0 0 C 0.09 0.414 0.175 0.707 0.326 0.86 C 0.497 1.046 0.791 0.985 1 1");
        interpolators.put("fast_out_extra_slow_in", "M 0 0 C 0.05 0 0.1333 0.06 0.1666 0.4 C 0.2083 0.82 0.25 1 1 1");
        interpolators.put("fast_out_linear_in", "M 0 0 C 0.4 0 1 1 1 1");
        interpolators.put("fast_out_slow_in", "M 0 0 C 0.4 0 0.2 1 1 1");
        interpolators.put("linear", "M 0,0 L 1,1");
        interpolators.put("linear_out_slow_in", "M 0,0 C 0,0 0.2,1 1,1");
        interpolators.put("overshoot", "M 0 0 C 0.035 0.136 0.157 0.855 0.39 1.063 C 0.586 1.25 0.81 0.996 1 1");
        this.interpolator = this.interpolator.replace("@android:interpolator/", "");
        this.interpolator = this.interpolator.replace("@android:anim/", "");
        this.interpolator = this.interpolator.replace("_interpolator", "");
        if (interpolators.containsKey(this.interpolator)) {
            this.interpolatorPathData = (String)interpolators.get(this.interpolator);
        }
    }

    public VectorDrawableObjectAnimator(String propertyname, float startoffset, float duration, float keepDuration, String interpolatorPathData, String valuefrom, String valueto, String pathData, float pivotX, float pivotY) {
        this.propertyname = propertyname;
        this.startoffset = startoffset;
        this.duration = duration;
        this.interpolatorPathData = interpolatorPathData;
        this.valuefrom = valuefrom;
        this.valueto = valueto;
        this.pathData = pathData;
        this.pivotX = pivotX;
        this.pivotY = pivotY;
        this.keepDuration = keepDuration;
    }

    public void setPivotX(float pivotX) {
        this.pivotX = pivotX;
    }

    public void setPivotY(float pivotY) {
        this.pivotY = pivotY;
    }

    public String getPropertyName() {
        return this.propertyname;
    }

    public float getStartOffset() {
        return this.startoffset;
    }

    public float getDuration() {
        return this.duration;
    }

    public String getInterpolatorPathData() {
        return this.interpolatorPathData;
    }

    public String getValueFrom() {
        return this.valuefrom;
    }

    public String getValueTo() {
        return this.valueto;
    }

    public void setKeepDuration(float keepDuration) {
        this.keepDuration = keepDuration;
    }

    public void updateTranslateX(float translateX) {
        if (this.propertyname.equals(VD_ATTRIBUTE_PROPERTYNAME_TRANSLATEX)) {
            this.valuefrom = Float.toString(Float.parseFloat(this.valuefrom) - translateX);
            this.valueto = Float.toString(Float.parseFloat(this.valueto) - translateX);
        }
        if (this.propertyname.equals(VD_ATTRIBUTE_PROPERTYNAME_TRANSLATEXY)) {
            AffineTransform atxy = new AffineTransform();
            atxy.translate(-translateX, 0.0);
            Shape s = ShapeUtils.getPathShape(this.pathData);
            s = atxy.createTransformedShape(s);
            this.pathData = ShapeUtils.getPathString(s);
        }
    }

    public void updateTranslateY(float translateY) {
        if (this.propertyname.equals(VD_ATTRIBUTE_PROPERTYNAME_TRANSLATEY)) {
            this.valuefrom = Float.toString(Float.parseFloat(this.valuefrom) - translateY);
            this.valueto = Float.toString(Float.parseFloat(this.valueto) - translateY);
        }
        if (this.propertyname.equals(VD_ATTRIBUTE_PROPERTYNAME_TRANSLATEXY)) {
            AffineTransform atxy = new AffineTransform();
            atxy.translate(0.0, -translateY);
            Shape s = ShapeUtils.getPathShape(this.pathData);
            s = atxy.createTransformedShape(s);
            this.pathData = ShapeUtils.getPathString(s);
        }
    }

    public void updateScaleX(float scaleX) {
        if (this.propertyname.equals(VD_ATTRIBUTE_PROPERTYNAME_SCALEX)) {
            this.valuefrom = Float.toString(Float.parseFloat(this.valuefrom) / scaleX);
            this.valueto = Float.toString(Float.parseFloat(this.valueto) / scaleX);
        }
    }

    public void updateScaleY(float scaleY) {
        if (this.propertyname.equals(VD_ATTRIBUTE_PROPERTYNAME_SCALEY)) {
            this.valuefrom = Float.toString(Float.parseFloat(this.valuefrom) / scaleY);
            this.valueto = Float.toString(Float.parseFloat(this.valueto) / scaleY);
        }
    }

    public void updateRotation(float rotation) {
        if (this.propertyname.equals(VD_ATTRIBUTE_PROPERTYNAME_ROTATION)) {
            this.valuefrom = Float.toString(Float.parseFloat(this.valuefrom) - rotation);
            this.valueto = Float.toString(Float.parseFloat(this.valueto) - rotation);
        }
    }

    public VGAnimation toVG() {
        int dur = (int)this.duration;
        int begin = (int)this.startoffset;
        int keepDur = (int)this.keepDuration;
        switch (this.propertyname) {
            case "translateX": {
                return new VGTranslateAnimation(dur, begin, keepDur, this.interpolatorPathData, Float.parseFloat(this.valueto) - Float.parseFloat(this.valuefrom), 0.0f, Float.parseFloat(this.valuefrom), 0.0f);
            }
            case "translateY": {
                return new VGTranslateAnimation(dur, begin, keepDur, this.interpolatorPathData, 0.0f, Float.parseFloat(this.valueto) - Float.parseFloat(this.valuefrom), 0.0f, Float.parseFloat(this.valuefrom));
            }
            case "translateXY": {
                return new VGTranslateXYAnimation(dur, begin, keepDur, this.interpolatorPathData, this.pathData);
            }
            case "scaleX": {
                return new VGScaleAnimation(dur, begin, keepDur, this.interpolatorPathData, Float.parseFloat(this.valuefrom), Float.parseFloat(this.valueto), 1.0f, 1.0f, this.pivotX, this.pivotY);
            }
            case "scaleY": {
                return new VGScaleAnimation(dur, begin, keepDur, this.interpolatorPathData, 1.0f, 1.0f, Float.parseFloat(this.valuefrom), Float.parseFloat(this.valueto), this.pivotX, this.pivotY);
            }
            case "rotation": {
                float startAngle = this.parseRotate(this.valuefrom, this.valueto, "startAngle");
                float rotationAngle = this.parseRotate(this.valuefrom, this.valueto, "rotationAngle");
                float startRotationCenterX = this.pivotX;
                float startRotationCenterY = this.pivotY;
                float rotationTranslationCenterX = 0.0f;
                float rotationTranslationCenterY = 0.0f;
                return new VGRotateAnimation(dur, begin, keepDur, this.interpolatorPathData, startAngle, rotationAngle, startRotationCenterX, startRotationCenterY, rotationTranslationCenterX, rotationTranslationCenterY);
            }
            case "fillColor": 
            case "strokeColor": {
                Color colorFrom = VGColor.createColor(this.valuefrom).getColor();
                Color colorTo = VGColor.createColor(this.valueto).getColor();
                return new VGColorAnimation(dur, begin, keepDur, this.interpolatorPathData, colorFrom.getRGB(), colorTo.getRGB());
            }
            case "fillAlpha": 
            case "strokeAlpha": {
                return new VGAlphaAnimation(dur, begin, keepDur, this.interpolatorPathData, (int)(Float.parseFloat(this.valuefrom) * 255.0f), (int)(Float.parseFloat(this.valueto) * 255.0f));
            }
            case "pathData": {
                return new VGPathDataAnimation(dur, begin, keepDur, this.interpolatorPathData, this.valuefrom, this.valueto);
            }
        }
        return null;
    }

    private float parseRotate(String from, String to, String attr) {
        String[] arrayFrom = from.split(" ");
        String[] arrayTo = to.split(" ");
        float startAngle = Float.parseFloat(from.split(" ")[0]);
        float rotationAngle = Float.parseFloat(to.split(" ")[0]) - Float.parseFloat(arrayFrom[0]);
        float startRotationCenterX = arrayFrom.length <= 1 ? 0.0f : Float.parseFloat(arrayFrom[1]);
        float startRotationCenterY = arrayFrom.length <= 2 ? 0.0f : Float.parseFloat(arrayFrom[2]);
        float rotationTranslationCenterX = arrayTo.length <= 1 ? -startRotationCenterX : Float.parseFloat(arrayTo[1]) - startRotationCenterX;
        float rotationTranslationCenterY = arrayTo.length <= 2 ? -startRotationCenterY : Float.parseFloat(arrayTo[2]) - startRotationCenterY;
        switch (attr) {
            case "startAngle": {
                return startAngle;
            }
            case "rotationAngle": {
                return rotationAngle;
            }
            case "startRotationCenterX": {
                return startRotationCenterX;
            }
            case "startRotationCenterY": {
                return startRotationCenterY;
            }
            case "rotationTranslationCenterX": {
                return rotationTranslationCenterX;
            }
            case "rotationTranslationCenterY": {
                return rotationTranslationCenterY;
            }
        }
        return 0.0f;
    }

    public String toString() {
        String logString = String.valueOf(this.propertyname) + " " + this.startoffset + " " + this.duration + " " + this.keepDuration;
        logString = this.propertyname.equals(VD_ATTRIBUTE_PROPERTYNAME_TRANSLATEXY) ? String.valueOf(logString) + " " + this.pathData : String.valueOf(logString) + " " + this.valuefrom + " " + this.valueto;
        if (this.propertyname.equals(VD_ATTRIBUTE_PROPERTYNAME_SCALEX) || this.propertyname.equals(VD_ATTRIBUTE_PROPERTYNAME_SCALEY) || this.propertyname.equals(VD_ATTRIBUTE_PROPERTYNAME_ROTATION)) {
            logString = String.valueOf(logString) + " " + this.pivotX + " " + this.pivotY;
        }
        return logString;
    }

    @Override
    public int compareTo(Object o) {
        VectorDrawableObjectAnimator other = (VectorDrawableObjectAnimator)o;
        Map<String, Integer> propertyNameMap = Stream.of({VD_ATTRIBUTE_PROPERTYNAME_TRANSLATEX, 1}, {VD_ATTRIBUTE_PROPERTYNAME_TRANSLATEY, 1}, {VD_ATTRIBUTE_PROPERTYNAME_TRANSLATEXY, 2}, {VD_ATTRIBUTE_PROPERTYNAME_SCALEX, 3}, {VD_ATTRIBUTE_PROPERTYNAME_SCALEY, 3}, {VD_ATTRIBUTE_PROPERTYNAME_ROTATION, 4}).collect(Collectors.toMap(data -> (String)data[0], data -> (Integer)data[1]));
        if (propertyNameMap.get(this.propertyname) == propertyNameMap.get(other.getPropertyName())) {
            return (int)(this.startoffset - other.startoffset);
        }
        return propertyNameMap.get(this.propertyname) - propertyNameMap.get(other.getPropertyName());
    }
}

