/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vd;

import com.microej.converter.vectorimage.Logger;
import com.microej.converter.vectorimage.vd.VectorDrawableObjectAnimator;
import com.microej.converter.vectorimage.vg.VGColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import org.w3c.dom.Element;

public class VectorDrawableGroupAnimations {
    ArrayList<VectorDrawableObjectAnimator> animations = new ArrayList();

    public VectorDrawableGroupAnimations() {
    }

    public VectorDrawableGroupAnimations(String targetName, ArrayList<Element> objectAnimatorList) {
        int i = 0;
        while (i < objectAnimatorList.size()) {
            VectorDrawableObjectAnimator objectAnimator = new VectorDrawableObjectAnimator(objectAnimatorList.get(i));
            this.animations.add(objectAnimator);
            ++i;
        }
        Logger.logDebugString(String.valueOf(targetName) + " animations before computation:" + this.animations.toString());
        this.convertToTranslateXY();
        this.extractAdditionalAlphaAnimations();
        this.computeKeepDuration();
        Logger.logDebugString(String.valueOf(targetName) + " animations after computation:" + this.animations.toString());
        Collections.sort(this.animations);
    }

    public VectorDrawableGroupAnimations(VectorDrawableObjectAnimator[] objectAnimatorList) {
        VectorDrawableObjectAnimator[] vectorDrawableObjectAnimatorArray = objectAnimatorList;
        int n = objectAnimatorList.length;
        int n2 = 0;
        while (n2 < n) {
            VectorDrawableObjectAnimator element = vectorDrawableObjectAnimatorArray[n2];
            this.animations.add(element);
            ++n2;
        }
    }

    public void add(VectorDrawableGroupAnimations animations) {
        this.animations.addAll(animations.get());
    }

    public void add(VectorDrawableObjectAnimator animation) {
        this.animations.add(animation);
    }

    public ArrayList<VectorDrawableObjectAnimator> get() {
        return this.animations;
    }

    public void convertToTranslateXY() {
        boolean hasTranslateXY = false;
        for (VectorDrawableObjectAnimator animation : this.animations) {
            if (!animation.getPropertyName().equals("translateXY")) continue;
            hasTranslateXY = true;
            break;
        }
        if (hasTranslateXY) {
            ArrayList<VectorDrawableObjectAnimator> txAnimations = new ArrayList<VectorDrawableObjectAnimator>();
            ArrayList<VectorDrawableObjectAnimator> tyAnimations = new ArrayList<VectorDrawableObjectAnimator>();
            for (VectorDrawableObjectAnimator animation : this.animations) {
                if (animation.getPropertyName().equals("translateX")) {
                    txAnimations.add(animation);
                }
                if (!animation.getPropertyName().equals("translateY")) continue;
                tyAnimations.add(animation);
            }
            for (VectorDrawableObjectAnimator txAnimation : txAnimations) {
                this.animations.remove(txAnimation);
                float startOffset = txAnimation.getStartOffset();
                float duration = txAnimation.getDuration();
                String interpolatorPathData = txAnimation.getInterpolatorPathData();
                VectorDrawableObjectAnimator tyAnimation = null;
                boolean hasAssociatedTy = false;
                for (VectorDrawableObjectAnimator tyAnimation2 : tyAnimations) {
                    tyAnimation = tyAnimation2;
                    if (startOffset != tyAnimation.getStartOffset() || duration != tyAnimation.getDuration() || !interpolatorPathData.equals(tyAnimation.getInterpolatorPathData())) continue;
                    hasAssociatedTy = true;
                    break;
                }
                String txValueFrom = txAnimation.getValueFrom();
                String txValueTo = txAnimation.getValueTo();
                String tyValueFrom = "0";
                String tyValueTo = "0";
                if (hasAssociatedTy) {
                    tyValueFrom = tyAnimation.getValueFrom();
                    tyValueTo = tyAnimation.getValueTo();
                    this.animations.remove(tyAnimation);
                    tyAnimations.remove(tyAnimation);
                }
                String pathData = "M" + txValueFrom + "," + tyValueFrom + " L" + txValueTo + "," + tyValueTo;
                VectorDrawableObjectAnimator txyAnimation = new VectorDrawableObjectAnimator("translateXY", startOffset, duration, 0.0f, interpolatorPathData, "", "", pathData, 0.0f, 0.0f);
                this.animations.add(txyAnimation);
            }
            for (VectorDrawableObjectAnimator tyAnimation : tyAnimations) {
                String txValueFrom = "0";
                String txValueTo = "0";
                String tyValueFrom = tyAnimation.getValueFrom();
                String tyValueTo = tyAnimation.getValueTo();
                String pathData = "M" + txValueFrom + "," + tyValueFrom + " L" + txValueTo + "," + tyValueTo;
                VectorDrawableObjectAnimator txyAnimation = new VectorDrawableObjectAnimator("translateXY", tyAnimation.getStartOffset(), tyAnimation.getDuration(), 0.0f, tyAnimation.getInterpolatorPathData(), "", "", pathData, 0.0f, 0.0f);
                this.animations.add(txyAnimation);
                this.animations.remove(tyAnimation);
            }
        }
    }

    public void extractAdditionalAlphaAnimations() {
        ArrayList<VectorDrawableObjectAnimator> newAnimations = new ArrayList<VectorDrawableObjectAnimator>();
        String[] colorNames = new String[]{"fillColor", "strokeColor"};
        String[] alphaNames = new String[]{"fillAlpha", "strokeAlpha"};
        int i = 0;
        while (i < colorNames.length) {
            for (VectorDrawableObjectAnimator animation : this.animations) {
                if (!animation.getPropertyName().equals(colorNames[i]) || 9 != animation.getValueFrom().length()) continue;
                Color colorFrom = VGColor.createColor(animation.getValueFrom()).getColor();
                Color colorTo = VGColor.createColor(animation.getValueTo()).getColor();
                if (colorFrom.getAlpha() == colorTo.getAlpha()) continue;
                float fromAlpha = (float)colorFrom.getAlpha() / 255.0f;
                float toAlpha = (float)colorTo.getAlpha() / 255.0f;
                VectorDrawableObjectAnimator alphaAnimation = new VectorDrawableObjectAnimator(alphaNames[i], animation.getStartOffset(), animation.getDuration(), 0.0f, animation.getInterpolatorPathData(), Float.toString(fromAlpha), Float.toString(toAlpha), "", 0.0f, 0.0f);
                newAnimations.add(alphaAnimation);
            }
            ++i;
        }
        this.animations.addAll(newAnimations);
    }

    public void computeKeepDuration() {
        String[] propertyNames;
        String[] stringArray = propertyNames = new String[]{"translateX", "translateY", "translateXY", "scaleX", "scaleY", "rotation", "fillColor", "strokeColor", "fillAlpha", "strokeAlpha", "pathData"};
        int n = propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            ArrayList<VectorDrawableObjectAnimator> localAnimations = new ArrayList<VectorDrawableObjectAnimator>();
            int i = 0;
            while (i < this.animations.size()) {
                if (propertyName.equals(this.animations.get(i).getPropertyName())) {
                    localAnimations.add(this.animations.get(i));
                }
                ++i;
            }
            if (localAnimations.size() != 0) {
                Collections.sort(localAnimations);
                i = 0;
                while (i < localAnimations.size() - 1) {
                    float untilNext = ((VectorDrawableObjectAnimator)localAnimations.get(i + 1)).getStartOffset() - (((VectorDrawableObjectAnimator)localAnimations.get(i)).getStartOffset() + ((VectorDrawableObjectAnimator)localAnimations.get(i)).getDuration());
                    if (untilNext > 0.0f) {
                        ((VectorDrawableObjectAnimator)localAnimations.get(i)).setKeepDuration(untilNext);
                    }
                    ++i;
                }
                ((VectorDrawableObjectAnimator)localAnimations.get(localAnimations.size() - 1)).setKeepDuration(-1.0f);
            }
            ++n2;
        }
    }

    public int size() {
        return this.animations.size();
    }

    public VectorDrawableObjectAnimator get(int i) {
        return this.animations.get(i);
    }

    public String toString() {
        String res = "";
        for (VectorDrawableObjectAnimator animation : this.animations) {
            res = String.valueOf(res) + animation + " / ";
        }
        return res;
    }
}

