/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vd;

import com.microej.converter.vectorimage.ShapeUtils;
import com.microej.converter.vectorimage.XmlUtils;
import com.microej.converter.vectorimage.vd.VectorDrawableClipPath;
import com.microej.converter.vectorimage.vd.VectorDrawableGroupAnimations;
import com.microej.converter.vectorimage.vd.VectorDrawableObjectAnimator;
import com.microej.converter.vectorimage.vd.VectorDrawableParser;
import com.microej.converter.vectorimage.vd.VectorDrawablePath;
import com.microej.converter.vectorimage.vg.VGAnimations;
import com.microej.converter.vectorimage.vg.VGGroup;
import com.microej.converter.vectorimage.vg.VGGroupAnimate;
import com.microej.converter.vectorimage.vg.VGGroupTransform;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VectorDrawableGroup {
    private static final String VD_ATTRIBUTE_NAME = "android:name";
    private static final String VD_ATTRIBUTE_ROTATION = "android:rotation";
    private static final String VD_ATTRIBUTE_PIVOTX = "android:pivotX";
    private static final String VD_ATTRIBUTE_PIVOTY = "android:pivotY";
    private static final String VD_ATTRIBUTE_SCALEX = "android:scaleX";
    private static final String VD_ATTRIBUTE_SCALEY = "android:scaleY";
    private static final String VD_ATTRIBUTE_TRANSLATEX = "android:translateX";
    private static final String VD_ATTRIBUTE_TRANSLATEY = "android:translateY";
    private static final String VD_ELEMENT_GROUP = "group";
    private static final String VD_ELEMENT_PATH = "path";
    private static final String VD_ELEMENT_CLIP_PATH = "clip-path";
    private static final float ZERO_SCALE = 1.0E-6f;
    private final List<Object> children = new ArrayList<Object>();
    private Shape clip;
    private final String name;
    private final float rotation;
    private final float pivotX;
    private final float pivotY;
    private float scaleX;
    private float scaleY;
    private final float translateX;
    private final float translateY;

    public VectorDrawableGroup(Element group) {
        this.rotation = XmlUtils.getAttribute(group, 0.0f, VD_ATTRIBUTE_ROTATION);
        this.pivotX = XmlUtils.getAttribute(group, 0.0f, VD_ATTRIBUTE_PIVOTX);
        this.pivotY = XmlUtils.getAttribute(group, 0.0f, VD_ATTRIBUTE_PIVOTY);
        this.scaleX = XmlUtils.getAttribute(group, 1.0f, VD_ATTRIBUTE_SCALEX);
        this.scaleY = XmlUtils.getAttribute(group, 1.0f, VD_ATTRIBUTE_SCALEY);
        this.translateX = XmlUtils.getAttribute(group, 0.0f, VD_ATTRIBUTE_TRANSLATEX);
        this.translateY = XmlUtils.getAttribute(group, 0.0f, VD_ATTRIBUTE_TRANSLATEY);
        this.name = XmlUtils.getAttribute(group, "NoName", VD_ATTRIBUTE_NAME);
        if (0.0f == this.scaleX) {
            this.scaleX = 1.0E-6f;
        }
        if (0.0f == this.scaleY) {
            this.scaleY = 1.0E-6f;
        }
        AffineTransform at = new AffineTransform();
        this.clip = at.createTransformedShape(this.clip);
        NodeList list = group.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            block18: {
                String elementName;
                Node node = list.item(i);
                if (1 != node.getNodeType() || node == null) break block18;
                Element element = (Element)node;
                switch (elementName = element.getNodeName()) {
                    case "group": {
                        this.children.add(new VectorDrawableGroup(element));
                        break;
                    }
                    case "path": {
                        VectorDrawablePath path = new VectorDrawablePath(element);
                        this.children.add(path);
                        break;
                    }
                    case "clip-path": {
                        Shape newClip;
                        this.clip = newClip = VectorDrawableClipPath.getShape(element);
                    }
                }
            }
            ++i;
        }
        if (VectorDrawableParser.animations.getAnimationsMap().containsKey(this.name)) {
            VectorDrawableGroupAnimations groupAnimations = VectorDrawableParser.animations.getAnimationsMap().get(this.name);
            int i2 = 0;
            while (i2 < groupAnimations.size()) {
                VectorDrawableObjectAnimator objectAnimator = groupAnimations.get(i2);
                objectAnimator.setPivotX(this.pivotX);
                objectAnimator.setPivotY(this.pivotY);
                objectAnimator.updateTranslateX(this.translateX);
                objectAnimator.updateTranslateY(this.translateY);
                objectAnimator.updateScaleX(this.scaleX);
                objectAnimator.updateScaleY(this.scaleY);
                objectAnimator.updateRotation(this.rotation);
                ++i2;
            }
        }
    }

    public void computePaths(VGGroup parent, int pathId, float alpha, AffineTransform at, Shape parentClip) {
        VectorDrawableGroupAnimations animations = new VectorDrawableGroupAnimations();
        this.computePaths(parent, pathId, alpha, at, animations, 0.0f, 0.0f, parentClip);
    }

    public int computePaths(VGGroup parent, int pathId, float alpha, AffineTransform at, VectorDrawableGroupAnimations animations, float parentPivotX, float parentPivotY, Shape parentClip) {
        VGGroup vgGroup;
        if (parentClip != null) {
            this.clip = ShapeUtils.clipShape(this.clip, parentClip);
        }
        AffineTransform groupAT = new AffineTransform(at);
        VectorDrawableGroupAnimations localAnimations = null;
        if (VectorDrawableParser.animations.getAnimationsMap().containsKey(this.name)) {
            localAnimations = VectorDrawableParser.animations.getAnimationsMap().get(this.name);
            VGAnimations vgAnimations = new VGAnimations();
            int i = 0;
            while (i < localAnimations.size()) {
                vgAnimations.add(localAnimations.get(i).toVG());
                ++i;
            }
            vgGroup = new VGGroupAnimate(this.name, vgAnimations, this.scaleX, this.scaleY, this.translateX, this.translateY, this.rotation, this.pivotX, this.pivotY);
        } else {
            vgGroup = new VGGroupTransform(this.name, this.scaleX, this.scaleY, this.translateX, this.translateY, this.rotation, this.pivotX, this.pivotY);
            if (!vgGroup.hasTransformations()) {
                vgGroup = new VGGroup(this.name);
            }
        }
        groupAT.translate(this.translateX, this.translateY);
        groupAT.translate(this.pivotX, this.pivotY);
        groupAT.rotate(Math.toRadians(this.rotation));
        groupAT.scale(this.scaleX, this.scaleY);
        groupAT.translate(-this.pivotX, -this.pivotY);
        parent.addChild(vgGroup);
        VectorDrawableGroupAnimations globalAnimations = new VectorDrawableGroupAnimations();
        if (animations != null) {
            globalAnimations.add(animations);
        }
        if (localAnimations != null) {
            globalAnimations.add(localAnimations);
        }
        for (Object child : this.children) {
            pathId = child instanceof VectorDrawableGroup ? ((VectorDrawableGroup)child).computePaths(vgGroup, pathId, alpha, groupAT, globalAnimations, this.pivotX, this.pivotY, this.clip) : ((VectorDrawablePath)child).computePaths(vgGroup, pathId, alpha, groupAT, globalAnimations, this.clip);
        }
        return pathId;
    }

    public String getName() {
        return this.name;
    }
}

