/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vd;

import com.microej.converter.vectorimage.XmlUtils;
import com.microej.converter.vectorimage.vd.VectorDrawableParser;
import com.microej.converter.vectorimage.vg.VGColor;
import com.microej.converter.vectorimage.vg.VGGradientStop;
import java.awt.Color;
import org.w3c.dom.Element;

public class VectorDrawableGradientItem {
    private static final String VD_ATTRIBUTE_OFFSET = "android:offset";
    private static final String VD_ATTRIBUTE_COLOR = "android:color";
    private final float offset;
    private final String color;

    public static VectorDrawableGradientItem parse(Element itemElement) {
        return new VectorDrawableGradientItem(XmlUtils.getAttribute(itemElement, "", VD_ATTRIBUTE_COLOR), XmlUtils.getAttribute(itemElement, 0.0f, VD_ATTRIBUTE_OFFSET));
    }

    public VectorDrawableGradientItem(String color, float offset) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.offset = offset;
        this.color = color;
    }

    public VGGradientStop toVG(float alpha) {
        VGGradientStop stop = new VGGradientStop(new VGColor(Color.BLACK));
        stop.setOffset(this.offset);
        stop.setColor(VGColor.createColor(this.color));
        if (9 == this.color.length()) {
            int opacity = VectorDrawableParser.getOpacity(this.color);
            stop.setOpacity((float)opacity / 256.0f * alpha);
        }
        return stop;
    }

    public String getColor() {
        return this.color;
    }
}

