/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vd;

import com.microej.converter.vectorimage.XmlUtils;
import com.microej.converter.vectorimage.vd.VectorDrawableGradientItem;
import com.microej.converter.vectorimage.vg.VGGradient;
import com.microej.converter.vectorimage.vg.VGGradientStop;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VectorDrawableGradient {
    private static final String VD_UNSUPPORTED_ERROR = "Unsupported %s '%s'.";
    private static final String VD_ATTRIBUTE_STARTY = "android:startY";
    private static final String VD_ATTRIBUTE_STARTX = "android:startX";
    private static final String VD_ATTRIBUTE_ENDY = "android:endY";
    private static final String VD_ATTRIBUTE_ENDX = "android:endX";
    private static final String VD_ATTRIBUTE_TYPE = "android:type";
    private static final String VD_ATTRIBUTE_STARTCOLOR = "android:startColor";
    private static final String VD_ATTRIBUTE_CENTERCOLOR = "android:centerColor";
    private static final String VD_ATTRIBUTE_ENDCOLOR = "android:endColor";
    private static final String VD_ATTRIBUTE_TYPE_LINEAR = "linear";
    private static final String VD_ELEMENT_ITEM = "item";
    private final List<VectorDrawableGradientItem> items;
    private final Rectangle2D.Float bounds;

    public static VectorDrawableGradient parse(Element aaptElement) {
        String type = XmlUtils.getAttribute(aaptElement, "", VD_ATTRIBUTE_TYPE);
        if (!type.isEmpty() && !type.toLowerCase().endsWith(VD_ATTRIBUTE_TYPE_LINEAR)) {
            return VectorDrawableGradient.create(new Rectangle2D.Float(), new ArrayList<VectorDrawableGradientItem>(), new ArrayList<VectorDrawableGradientItem>());
        }
        NodeList itemList = aaptElement.getChildNodes();
        ArrayList<VectorDrawableGradientItem> items = new ArrayList<VectorDrawableGradientItem>();
        int j = 0;
        while (j < itemList.getLength()) {
            Element itemElement;
            String itemElementName;
            Node itemNode = itemList.item(j);
            if (1 == itemNode.getNodeType() && VD_ELEMENT_ITEM == (itemElementName = (itemElement = (Element)itemNode).getNodeName())) {
                items.add(VectorDrawableGradientItem.parse(itemElement));
            }
            ++j;
        }
        ArrayList<VectorDrawableGradientItem> fallbackColors = new ArrayList<VectorDrawableGradientItem>();
        VectorDrawableGradient.addFallbackColors(fallbackColors, XmlUtils.getAttribute(aaptElement, null, VD_ATTRIBUTE_STARTCOLOR), XmlUtils.getAttribute(aaptElement, null, VD_ATTRIBUTE_CENTERCOLOR), XmlUtils.getAttribute(aaptElement, null, VD_ATTRIBUTE_ENDCOLOR));
        float startX = XmlUtils.getAttribute(aaptElement, 0.0f, VD_ATTRIBUTE_STARTX);
        float startY = XmlUtils.getAttribute(aaptElement, 0.0f, VD_ATTRIBUTE_STARTY);
        float endX = XmlUtils.getAttribute(aaptElement, 0.0f, VD_ATTRIBUTE_ENDX);
        float endY = XmlUtils.getAttribute(aaptElement, 0.0f, VD_ATTRIBUTE_ENDY);
        Rectangle2D.Float bounds = new Rectangle2D.Float(startX, startY, endX - startX, endY - startY);
        return VectorDrawableGradient.create(bounds, items, fallbackColors);
    }

    public static void addFallbackColors(List<VectorDrawableGradientItem> fallbackColors, String start, String center, String stop) {
        if (start != null) {
            fallbackColors.add(new VectorDrawableGradientItem(start, 0.0f));
        }
        if (center != null) {
            fallbackColors.add(new VectorDrawableGradientItem(center, 0.5f));
        }
        if (stop != null) {
            fallbackColors.add(new VectorDrawableGradientItem(stop, 1.0f));
        }
    }

    public static VectorDrawableGradient create(Rectangle2D.Float bounds, List<VectorDrawableGradientItem> items, List<VectorDrawableGradientItem> fallbackColors) {
        if (items.isEmpty()) {
            return new VectorDrawableGradient(bounds, fallbackColors);
        }
        return new VectorDrawableGradient(bounds, items);
    }

    private VectorDrawableGradient(Rectangle2D.Float bounds, List<VectorDrawableGradientItem> items) {
        this.bounds = bounds;
        this.items = items;
    }

    public VGGradient toVG(float alpha) {
        VGGradient gradient = new VGGradient();
        gradient.setX1((float)this.bounds.getX());
        gradient.setY1((float)this.bounds.getY());
        gradient.setX2((float)this.bounds.getMaxX());
        gradient.setY2((float)this.bounds.getMaxY());
        ArrayList<VGGradientStop> stopsList = new ArrayList<VGGradientStop>();
        for (VectorDrawableGradientItem item : this.items) {
            VGGradientStop gradientStop = item.toVG(alpha);
            stopsList.add(gradientStop);
        }
        if (!stopsList.isEmpty()) {
            gradient.setStops(stopsList.toArray(new VGGradientStop[stopsList.size()]));
        }
        return gradient;
    }
}

