/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.vd;

import com.microej.converter.vectorimage.XmlUtils;
import com.microej.converter.vectorimage.vd.VectorDrawableGroupAnimations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VectorDrawableAnimations {
    private static final String VD_ATTRIBUTE_NAME = "android:name";
    private static Map<String, VectorDrawableGroupAnimations> groupAnimationsMap = null;

    public VectorDrawableAnimations(Element root) {
        groupAnimationsMap = new HashMap<String, VectorDrawableGroupAnimations>();
        ArrayList<Element> targetElementList = this.getElementChildren(root, "target");
        for (Element targetElement : targetElementList) {
            String targetName = XmlUtils.getAttribute(targetElement, "", VD_ATTRIBUTE_NAME);
            ArrayList<Element> objectAnimatorList = this.getElementChildren(targetElement, "objectAnimator");
            VectorDrawableGroupAnimations groupAnimations = new VectorDrawableGroupAnimations(targetName, objectAnimatorList);
            if (groupAnimationsMap.containsKey(targetName)) {
                VectorDrawableGroupAnimations previousAnimations = groupAnimationsMap.get(targetName);
                previousAnimations.add(groupAnimations);
                groupAnimationsMap.put(targetName, previousAnimations);
                continue;
            }
            groupAnimationsMap.put(targetName, groupAnimations);
        }
    }

    public Map<String, VectorDrawableGroupAnimations> getAnimationsMap() {
        return groupAnimationsMap;
    }

    private ArrayList<Element> getElementChildren(Element element, String elementName) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        if (elementName == element.getNodeName()) {
            elementList.add(element);
        }
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (1 == node.getNodeType() && node != null) {
                Element child = (Element)node;
                ArrayList<Object> childElementList = new ArrayList();
                childElementList = this.getElementChildren(child, elementName);
                elementList.addAll(childElementList);
            }
            ++i;
        }
        return elementList;
    }
}

