/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.svg;

import com.microej.converter.vectorimage.Logger;
import com.microej.converter.vectorimage.XmlUtils;
import com.microej.converter.vectorimage.svg.SVGGradient;
import com.microej.converter.vectorimage.svg.SVGParser;
import com.microej.converter.vectorimage.vg.VGColor;
import com.microej.converter.vectorimage.vg.VGStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import org.apache.batik.anim.dom.SVGStylableElement;
import org.w3c.dom.Element;

public class SVGStyle {
    private static final String SVG_STYLE_ATTRIBUTE_NAME = "style";
    private static final String SVG_FILL_ATTRIBUTE_NAME = "fill";
    private static final String SVG_FILL_RULE_ATTRIBUTE_NAME = "fill-rule";
    private static final String SVG_OPACITY_ATTRIBUTE_NAME = "opacity";
    private static final String SVG_FILL_OPACITY_ATTRIBUTE_NAME = "fill-opacity";
    private static final String SVG_STROKE_ATTRIBUTE_NAME = "stroke";
    private static final String SVG_STROKE_WIDTH_ATTRIBUTE_NAME = "stroke-width";
    private static final String SVG_STROKE_OPACITY_ATTRIBUTE_NAME = "stroke-opacity";
    private static final String SVG_STROKE_LINECAP_ATTRIBUTE_NAME = "stroke-linecap";
    private static final String SVG_STROKE_LINEJOIN_ATTRIBUTE_NAME = "stroke-linejoin";
    private static final String SVG_STROKE_MITERLIMIT_ATTRIBUTE_NAME = "stroke-miterlimit";
    private static final String SVG_STROKE_DASHARRAY_ATTRIBUTE_NAME = "stroke-dasharray";
    private static final String SVG_STROKE_DASHOFFSET_ATTRIBUTE_NAME = "stroke-dashoffset";
    private static final String SVG_COLOR_ATTRIBUTE_NAME = "color";
    private static final String SVG_CLASS_ATTRIBUTE_NAME = "class";
    private static final String SVG_PAINT_ORDER_ATTRIBUTE_NAME = "paint-order";
    private static final String SVG_FONT_STYLE_PREFIX = "font-";
    private static final String SVG_STROKE_LINECAP_BUTT = "butt";
    private static final String SVG_STROKE_LINECAP_ROUND = "round";
    private static final String SVG_STROKE_LINECAP_SQUARE = "square";
    private static final String SVG_STROKE_LINEJOIN_BEVEL = "bevel";
    private static final String SVG_STROKE_LINEJOIN_MITER = "miter";
    private static final String SVG_STROKE_LINEJOIN_ROUND = "round";
    private static final Color DEFAULT_FILL_COLOR = Color.black;
    private static final String NONZERO_FILLRULE = "nonzero";
    private static final String EVENODD_FILLRULE = "evenodd";
    private static final String DEFAULT_FILLRULE = "nonzero";
    private static final String DEFAULT_STROKE_WIDTH = "1";
    private static final float DEFAULT_STROKE_MITERLIMIT = 4.0f;
    private static final String DEFAULT_PAINT_ORDER = "normal";
    private final SVGParser svgParser;
    private float opacity;
    private VGColor fill;
    private boolean nofill;
    private SVGGradient gradient;
    private String fillRule;
    private VGColor stroke;
    private final boolean strokeNofill;
    private String strokeWidth;
    private float strokeOpacity;
    private String strokeLinecap;
    private String strokeLinejoin;
    private float strokeMiterlimit;
    private float[] strokeDash;
    private float strokeDashphase;
    private SVGGradient strokeGradient;
    private String paintOrder;
    private String color;

    public SVGStyle(SVGParser svgParser) {
        this.svgParser = svgParser;
        this.opacity = 1.0f;
        this.fill = new VGColor(DEFAULT_FILL_COLOR);
        this.nofill = false;
        this.gradient = null;
        this.fillRule = "nonzero";
        this.stroke = null;
        this.strokeNofill = false;
        this.strokeWidth = DEFAULT_STROKE_WIDTH;
        this.strokeOpacity = 1.0f;
        this.strokeLinecap = SVG_STROKE_LINECAP_BUTT;
        this.strokeLinejoin = SVG_STROKE_LINEJOIN_MITER;
        this.strokeMiterlimit = 4.0f;
        this.strokeDash = null;
        this.strokeDashphase = 0.0f;
        this.strokeGradient = null;
        this.paintOrder = DEFAULT_PAINT_ORDER;
        this.color = "black";
    }

    public SVGStyle(SVGParser svgParser, SVGStyle other) {
        this.svgParser = svgParser;
        this.opacity = other.opacity;
        this.fill = other.fill;
        this.nofill = other.nofill;
        if (other.gradient != null) {
            this.gradient = new SVGGradient(other.gradient);
        }
        this.fillRule = other.fillRule;
        this.stroke = other.stroke;
        this.strokeWidth = other.strokeWidth;
        this.strokeNofill = other.strokeNofill;
        this.strokeOpacity = other.strokeOpacity;
        this.strokeLinecap = other.strokeLinecap;
        this.strokeLinejoin = other.strokeLinejoin;
        this.strokeMiterlimit = other.strokeMiterlimit;
        this.strokeDash = other.strokeDash;
        this.strokeDashphase = other.strokeDashphase;
        if (other.strokeGradient != null) {
            this.strokeGradient = new SVGGradient(other.strokeGradient);
        }
        this.paintOrder = other.paintOrder;
        this.color = other.color;
    }

    public void updateStyle(Element element) {
        this.updateStyleFromClass((SVGStylableElement)element);
        if (element.hasAttribute(SVG_STYLE_ATTRIBUTE_NAME)) {
            this.updateStyleFromString(element.getAttribute(SVG_STYLE_ATTRIBUTE_NAME));
        }
        this.opacity = XmlUtils.getAttribute(element, this.opacity, SVG_OPACITY_ATTRIBUTE_NAME);
        this.fillRule = XmlUtils.getAttribute(element, this.fillRule, SVG_FILL_RULE_ATTRIBUTE_NAME);
        this.strokeWidth = XmlUtils.getAttribute(element, this.strokeWidth, SVG_STROKE_WIDTH_ATTRIBUTE_NAME);
        this.strokeLinecap = XmlUtils.getAttribute(element, this.strokeLinecap, SVG_STROKE_LINECAP_ATTRIBUTE_NAME);
        this.strokeLinejoin = XmlUtils.getAttribute(element, this.strokeLinejoin, SVG_STROKE_LINEJOIN_ATTRIBUTE_NAME);
        this.strokeMiterlimit = XmlUtils.getAttribute(element, this.strokeMiterlimit, SVG_STROKE_MITERLIMIT_ATTRIBUTE_NAME);
        this.strokeDashphase = XmlUtils.getAttribute(element, this.strokeDashphase, SVG_STROKE_DASHOFFSET_ATTRIBUTE_NAME);
        String newColor = XmlUtils.getAttribute(element, this.color, SVG_COLOR_ATTRIBUTE_NAME);
        if (!newColor.equals("inherit")) {
            this.color = newColor;
        }
        if (element.hasAttribute(SVG_FILL_ATTRIBUTE_NAME)) {
            this.updateFill(element.getAttribute(SVG_FILL_ATTRIBUTE_NAME));
        }
        if (element.hasAttribute(SVG_OPACITY_ATTRIBUTE_NAME)) {
            this.updateFillOpacity(element.getAttribute(SVG_OPACITY_ATTRIBUTE_NAME));
        }
        if (element.hasAttribute(SVG_FILL_OPACITY_ATTRIBUTE_NAME)) {
            this.updateFillOpacity(element.getAttribute(SVG_FILL_OPACITY_ATTRIBUTE_NAME));
        }
        if (element.hasAttribute(SVG_STROKE_ATTRIBUTE_NAME)) {
            this.updateStroke(element.getAttribute(SVG_STROKE_ATTRIBUTE_NAME));
        }
        if (element.hasAttribute(SVG_STROKE_OPACITY_ATTRIBUTE_NAME)) {
            this.updateStrokeOpacity(element.getAttribute(SVG_STROKE_OPACITY_ATTRIBUTE_NAME));
        }
        if (element.hasAttribute(SVG_STROKE_DASHARRAY_ATTRIBUTE_NAME)) {
            this.updateStrokeDasharray(element.getAttribute(SVG_STROKE_DASHARRAY_ATTRIBUTE_NAME));
        }
    }

    private void updateStyleFromClass(SVGStylableElement element) {
        if (element.hasAttribute(SVG_CLASS_ATTRIBUTE_NAME)) {
            String c = element.getAttribute(SVG_CLASS_ATTRIBUTE_NAME);
            String svgClass = this.svgParser.getSvgClass(c);
            if (svgClass == null) {
                Logger.logWarnString(String.format("Unknown %s '%s' (ignored).", "class in style", c));
            } else {
                this.updateStyleFromString(svgClass);
            }
        }
    }

    private void updateStyleFromString(String styleString) {
        String[] stringArray = styleString.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String strStyleElement = stringArray[n2];
            this.fillRule = XmlUtils.parseStyle(strStyleElement, this.fillRule, SVG_FILL_RULE_ATTRIBUTE_NAME);
            this.strokeWidth = XmlUtils.parseStyle(strStyleElement, this.strokeWidth, SVG_STROKE_WIDTH_ATTRIBUTE_NAME);
            this.strokeLinecap = XmlUtils.parseStyle(strStyleElement, this.strokeLinecap, SVG_STROKE_LINECAP_ATTRIBUTE_NAME);
            this.strokeLinejoin = XmlUtils.parseStyle(strStyleElement, this.strokeLinejoin, SVG_STROKE_LINEJOIN_ATTRIBUTE_NAME);
            this.strokeMiterlimit = XmlUtils.parseStyle(strStyleElement, this.strokeMiterlimit, SVG_STROKE_MITERLIMIT_ATTRIBUTE_NAME);
            this.strokeDashphase = XmlUtils.parseStyle(strStyleElement, this.strokeDashphase, SVG_STROKE_DASHOFFSET_ATTRIBUTE_NAME);
            this.paintOrder = XmlUtils.parseStyle(strStyleElement, this.paintOrder, SVG_PAINT_ORDER_ATTRIBUTE_NAME);
            String[] styleElement = strStyleElement.split(":");
            switch (styleElement[0]) {
                case "fill": {
                    this.updateFill(styleElement[1]);
                    break;
                }
                case "stroke": {
                    this.updateStroke(styleElement[1]);
                    break;
                }
                case "opacity": 
                case "fill-opacity": {
                    this.updateFillOpacity(styleElement[1]);
                    break;
                }
                case "stroke-opacity": {
                    this.updateStrokeOpacity(styleElement[1]);
                    break;
                }
                case "stroke-dasharray": {
                    this.updateStrokeDasharray(styleElement[1]);
                    break;
                }
                default: {
                    if (styleElement[0].startsWith(SVG_FONT_STYLE_PREFIX)) break;
                    Logger.logWarnString(String.format("Unsupported %s '%s'.", SVG_STYLE_ATTRIBUTE_NAME, styleElement[0]));
                }
                case "stroke-width": 
                case "fill-rule": 
                case "stroke-dashoffset": 
                case "stroke-miterlimit": 
                case "stroke-linejoin": 
                case "stroke-linecap": 
            }
            ++n2;
        }
    }

    private void updateFill(String fill) {
        if (fill != null) {
            if (fill.equals("currentColor")) {
                fill = this.color;
            }
            if (fill.startsWith("url")) {
                String url = fill.substring(5, fill.length() - 1);
                SVGGradient svgGradient = this.svgParser.getGradient(url);
                if (svgGradient != null) {
                    this.gradient = svgGradient;
                } else {
                    Logger.logWarnString(String.format("Unknown %s '%s' (ignored).", "url", url));
                }
            } else if (fill.equals("none")) {
                this.nofill = true;
            } else {
                VGColor svgFill;
                if ('#' == fill.charAt(0) && 9 == fill.length()) {
                    String alpha = fill.substring(7, 9);
                    fill = fill.substring(0, 7);
                    this.opacity *= (float)Integer.parseInt(alpha, 16) / 255.0f;
                }
                if (fill.contains("rgba")) {
                    fill = fill.replace("rgba", "").replace(" ", "").replace("(", "").replace(")", "");
                    String[] rgba = fill.split(",");
                    this.opacity *= Float.parseFloat(rgba[3]);
                    fill = "rgb(" + rgba[0] + "," + rgba[1] + "," + rgba[2] + ")";
                }
                if ((svgFill = VGColor.createColor(fill)) != null) {
                    this.fill = svgFill;
                    this.nofill = false;
                }
            }
        }
    }

    private void updateStroke(String stroke) {
        if (stroke != null) {
            if (stroke.equals("currentColor")) {
                stroke = this.color;
            }
            if (stroke.startsWith("url")) {
                String url = stroke.substring(5, stroke.length() - 1);
                SVGGradient svgGradient = this.svgParser.getGradient(url);
                if (svgGradient != null) {
                    this.strokeGradient = svgGradient;
                } else {
                    Logger.logWarnString(String.format("Unknown %s '%s' (ignored).", "url", url));
                }
            } else if (!stroke.equals("none")) {
                VGColor svgStroke;
                if ('#' == stroke.charAt(0) && 9 == stroke.length()) {
                    String alpha = stroke.substring(7, 9);
                    stroke = stroke.substring(0, 7);
                    this.strokeOpacity *= (float)Integer.parseInt(alpha, 16) / 255.0f;
                }
                if (stroke.contains("rgba")) {
                    stroke = stroke.replace("rgba", "").replace(" ", "").replace("(", "").replace(")", "");
                    String[] rgba = stroke.split(",");
                    this.strokeOpacity *= Float.parseFloat(rgba[3]);
                    stroke = "rgb(" + rgba[0] + "," + rgba[1] + "," + rgba[2] + ")";
                }
                if ((svgStroke = VGColor.createColor(stroke)) != null) {
                    this.stroke = svgStroke;
                }
            }
        }
    }

    private void updateFillOpacity(String fillOpacity) {
        if (fillOpacity != null) {
            float svgFillOpacity = 0.0f;
            if (fillOpacity.contains("%")) {
                fillOpacity = fillOpacity.replace("%", "");
                svgFillOpacity = Float.parseFloat(fillOpacity) / 100.0f;
            } else {
                svgFillOpacity = Float.parseFloat(fillOpacity);
            }
            svgFillOpacity = this.clampOpacity(svgFillOpacity);
            this.opacity *= svgFillOpacity;
        }
    }

    private void updateStrokeOpacity(String strokeOpacity) {
        if (strokeOpacity != null) {
            float svgStrokeOpacity = 0.0f;
            if (strokeOpacity.contains("%")) {
                strokeOpacity = strokeOpacity.replace("%", "");
                svgStrokeOpacity = Float.parseFloat(strokeOpacity) / 100.0f;
            } else {
                svgStrokeOpacity = Float.parseFloat(strokeOpacity);
            }
            svgStrokeOpacity = this.clampOpacity(svgStrokeOpacity);
            this.strokeOpacity *= svgStrokeOpacity;
        }
    }

    private float clampOpacity(float opacity) {
        opacity = Math.max(opacity, 0.0f);
        opacity = Math.min(opacity, 1.0f);
        return opacity;
    }

    private void updateStrokeDasharray(String strokedasharray) {
        if (strokedasharray != null && !strokedasharray.equals("none")) {
            String[] strokedasharrayel = strokedasharray.replace(",", " ").replace("  ", " ").split(" ");
            float[] strokeDasharray = new float[strokedasharrayel.length];
            int i = 0;
            while (i < strokedasharrayel.length) {
                int n = i;
                strokeDasharray[n] = strokeDasharray[n] + Float.parseFloat(strokedasharrayel[i]);
                ++i;
            }
            this.strokeDash = strokeDasharray;
        }
    }

    public float getFillOpacity() {
        return this.opacity;
    }

    public float getStrokeOpacity() {
        return this.strokeOpacity;
    }

    public VGColor getStroke() {
        return this.stroke;
    }

    public float getStrokeWidth() {
        if (this.strokeWidth.contains("%")) {
            this.strokeWidth = this.strokeWidth.replace("%", "");
            Logger.logWarnString("% is not supported in strokewidth, will be replace by " + this.strokeWidth);
        }
        return Float.parseFloat(this.strokeWidth);
    }

    public SVGGradient getStrokeGradient() {
        return this.strokeGradient;
    }

    /*
     * Exception decompiling
     */
    public BasicStroke getBasicStroke() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl32 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl32 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public VGStyle toVG(boolean fromStroke) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl24 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl24 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

