/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.svg;

import com.microej.converter.vectorimage.Logger;
import com.microej.converter.vectorimage.ShapeUtils;
import com.microej.converter.vectorimage.svg.SVGAnimation;
import com.microej.converter.vectorimage.svg.SVGParser;
import com.microej.converter.vectorimage.svg.SVGStyle;
import com.microej.converter.vectorimage.vg.VGAnimations;
import com.microej.converter.vectorimage.vg.VGGradient;
import com.microej.converter.vectorimage.vg.VGGroup;
import com.microej.converter.vectorimage.vg.VGPath;
import com.microej.converter.vectorimage.vg.VGStyle;
import com.microej.converter.vectorimage.vg.VGUtils;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.anim.dom.SVGOMAnimateTransformElement;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGPath {
    private static final String SVG_ELEMENT_TSPAN = "tspan";
    private static final String SVG_TSPAN_WARNING = "text tspan detected for text %s. tspan supported if tspan colors are identical.";
    SVGStyle style;
    Shape shape;
    AffineTransform at;
    ArrayList<SVGAnimation> animateTransform = new ArrayList();

    public SVGPath(SVGParser svgParser, Element element, SVGStyle style) {
        if (1.0f != style.getFillOpacity() || 1.0f != style.getStrokeOpacity()) {
            Logger.logErrString("Group opacity detected, can lead to unexpected drawings.");
        }
        this.style = new SVGStyle(svgParser, style);
        this.style.updateStyle(element);
        GraphicsNode gvtNode = SVGParser.ctx.getGraphicsNode(element);
        this.shape = gvtNode.getOutline();
        this.at = gvtNode.getGlobalTransform();
        if (3 == element.getNodeType() && element.hasChildNodes()) {
            NodeList list = element.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (SVG_ELEMENT_TSPAN.equals(node.getNodeName())) {
                    Logger.logWarnString(String.format(SVG_TSPAN_WARNING, node.getTextContent()));
                }
                ++i;
            }
        }
        int i = 0;
        while (i < element.getChildNodes().getLength()) {
            if (element.getChildNodes().item(i) instanceof SVGOMAnimateTransformElement) {
                this.animateTransform.add(new SVGAnimation((SVGOMAnimateTransformElement)element.getChildNodes().item(i)));
            }
            ++i;
        }
    }

    public int computePaths(VGGroup parent, int pathId, List<SVGAnimation> animateTransform, Shape parentClip) {
        VGPath vgPath;
        String pathStringTransformed;
        Shape drawnShape;
        String idString;
        animateTransform.addAll(this.animateTransform);
        VGAnimations animations = new VGAnimations();
        for (SVGAnimation element : animateTransform) {
            animations.add(element.toVG());
        }
        VGStyle pathStyle = this.style.toVG(false);
        VGGradient styleGradient = pathStyle.getGradient();
        if (styleGradient != null && VGGradient.GradientUnit.USERSPACEONUSE == styleGradient.getGradientUnits()) {
            styleGradient.addTransform(this.at);
        }
        if (pathStyle.getPaintOrder().startsWith("fill") || pathStyle.getPaintOrder().startsWith("normal")) {
            idString = "shapepath" + pathId++;
            drawnShape = this.at.createTransformedShape(this.shape);
            drawnShape = ShapeUtils.clipShape(drawnShape, parentClip);
            pathStringTransformed = ShapeUtils.getPathString(drawnShape);
            vgPath = VGUtils.createVGPath(idString, pathStringTransformed, pathStyle, animations, new VGAnimations(), new VGAnimations(), new VGAnimations());
            parent.addChild(vgPath);
        }
        if ((this.style.getStroke() != null || this.style.getStrokeGradient() != null) && 0.0f != this.style.getStrokeWidth()) {
            VGStyle strokeStyle = this.style.toVG(true);
            Shape strokeShape = this.style.getBasicStroke().createStrokedShape(this.shape);
            VGGradient strokeStyleGradient = strokeStyle.getGradient();
            if (strokeStyleGradient != null && VGGradient.GradientUnit.USERSPACEONUSE == strokeStyleGradient.getGradientUnits()) {
                strokeStyleGradient.addTransform(this.at);
            }
            String idString2 = "Shapepath" + pathId++;
            strokeShape = this.at.createTransformedShape(strokeShape);
            strokeShape = ShapeUtils.clipShape(strokeShape, parentClip);
            String pathStringTransformed2 = ShapeUtils.getPathString(strokeShape);
            VGPath vgPath2 = VGUtils.createVGPath(idString2, pathStringTransformed2, strokeStyle, animations, new VGAnimations(), new VGAnimations(), new VGAnimations());
            parent.addChild(vgPath2);
        }
        if (pathStyle.getPaintOrder().startsWith("stroke") || pathStyle.getPaintOrder().startsWith("markers")) {
            idString = "shapepath" + pathId++;
            drawnShape = this.at.createTransformedShape(this.shape);
            drawnShape = ShapeUtils.clipShape(drawnShape, parentClip);
            pathStringTransformed = ShapeUtils.getPathString(drawnShape);
            vgPath = VGUtils.createVGPath(idString, pathStringTransformed, pathStyle, animations, new VGAnimations(), new VGAnimations(), new VGAnimations());
            parent.addChild(vgPath);
        }
        return pathId;
    }
}

