/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.svg;

import com.microej.converter.vectorimage.FileParser;
import com.microej.converter.vectorimage.Logger;
import com.microej.converter.vectorimage.svg.SVGAnimation;
import com.microej.converter.vectorimage.svg.SVGGradient;
import com.microej.converter.vectorimage.svg.SVGGroup;
import com.microej.converter.vectorimage.svg.SVGStyle;
import com.microej.converter.vectorimage.vg.VGGroup;
import com.microej.converter.vectorimage.vg.VGGroupMaster;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGOMClipPathElement;
import org.apache.batik.anim.dom.SVGOMStyleElement;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGParser
extends FileParser {
    public static final String SVG_UNKNOWN_ERROR = "Unknown %s '%s' (ignored).";
    public static final String SVG_UNSUPPORTED_ERROR = "Unsupported %s '%s'.";
    private static final String SVG_ROOT_NODE_NAME = "svg";
    private static final String SVG_ROOT_NODE_NAME_ERROR = "Expecting xml node 'svg'";
    private static final String SVG_METADATA_ELEMENT_NAME = "metadata";
    private static final String SVG_DEFS_ELEMENT_NAME = "defs";
    private static final String SVG_SODIPODI_NAMEDVIEW_ELEMENT_NAME = "sodipodi:namedview";
    private static final String SVG_STYLE_ELEMENT_NAME = "style";
    private static final String SVG_CLIPPATH_ELEMENT_NAME = "clipPath";
    private static final String SVG_PATH_ELEMENT_NAME = "path";
    private static final String SVG_LINEAR_GRADIENT_ELEMENT_NAME = "linearGradient";
    private static final String SVG_XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    private static final String SVG_XLINK_HREF_ATTRIBUTE_NAME = "href";
    private static final String SVG_CLIPPATH_ID_ATTRIBUTE_NAME = "id";
    private static final String SVG_PATH_D_ATTRIBUTE_NAME = "d";
    private final Map<String, SVGGradient> gradients = new HashMap<String, SVGGradient>();
    private final Map<String, String> classes = new HashMap<String, String>();
    private final Map<String, String> clipPaths = new HashMap<String, String>();
    static final BridgeContext ctx;
    private String svgWidth;
    private String svgHeight;

    static {
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader(userAgent);
        ctx = new BridgeContext(userAgent, loader);
        ctx.setDynamicState(2);
    }

    public SVGParser(String inFilePath) throws FileNotFoundException, IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        SVGDocument doc = f.createSVGDocument(null, new FileInputStream(inFilePath));
        this.parseSVGSize(doc);
        SVGSVGElement el = doc.getRootElement();
        el.setAttribute("version", "1.0");
        GVTBuilder builder = new GVTBuilder();
        builder.build(ctx, doc);
        Element root = doc.getDocumentElement();
        if (root.getNodeName() != SVG_ROOT_NODE_NAME) {
            throw new RuntimeException(SVG_ROOT_NODE_NAME_ERROR);
        }
        this.topGroup = new VGGroupMaster();
        this.parseSVGElement(root, this.topGroup);
    }

    public String getClipPath(String clipPathId) {
        return this.clipPaths.get(clipPathId);
    }

    public String getSvgClass(String classId) {
        return this.classes.get(classId);
    }

    public SVGGradient getGradient(String gradientId) {
        return this.gradients.get(gradientId);
    }

    public void parseSVGElement(Element group, VGGroup parent) {
        NodeList list = group.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            block19: {
                String elementName;
                Node node = list.item(i);
                if (1 != node.getNodeType()) break block19;
                Element element = (Element)node;
                switch (elementName = element.getNodeName()) {
                    case "metadata": 
                    case "sodipodi:namedview": {
                        Logger.logWarnString(String.format(SVG_UNSUPPORTED_ERROR, "XML element", elementName));
                        break;
                    }
                    case "style": {
                        this.parseStyle((SVGOMStyleElement)element);
                        break;
                    }
                    case "defs": {
                        this.parseDefs(element);
                        break;
                    }
                    case "linearGradient": {
                        this.parseLinearGradient(element);
                    }
                }
            }
            ++i;
        }
        SVGGroup g = new SVGGroup(this, group, new SVGStyle(this));
        ArrayList<SVGAnimation> animateTransform = new ArrayList<SVGAnimation>();
        Rectangle2D.Float topclip = new Rectangle2D.Float(0.0f, 0.0f, this.getSVGWidth(), this.getSVGHeight());
        g.computePaths(parent, 0, animateTransform, topclip);
    }

    private void parseDefs(Element defs) {
        NodeList list = defs.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            block14: {
                String elementName;
                Node node = list.item(i);
                if (1 != node.getNodeType()) break block14;
                Element element = (Element)node;
                switch (elementName = element.getNodeName()) {
                    case "linearGradient": {
                        this.parseLinearGradient(element);
                        break;
                    }
                    case "style": {
                        this.parseStyle((SVGOMStyleElement)element);
                        break;
                    }
                    case "clipPath": {
                        this.parseClipPath((SVGOMClipPathElement)element);
                        break;
                    }
                    default: {
                        Logger.logWarnString(String.format(SVG_UNSUPPORTED_ERROR, "XML element in <defs>", elementName));
                    }
                }
            }
            ++i;
        }
    }

    void parseLinearGradient(Element linearGradient) {
        SVGGradient fallback = null;
        if (linearGradient.hasAttributeNS(SVG_XLINK_NAMESPACE, SVG_XLINK_HREF_ATTRIBUTE_NAME)) {
            String xlink = linearGradient.getAttributeNS(SVG_XLINK_NAMESPACE, SVG_XLINK_HREF_ATTRIBUTE_NAME);
            fallback = this.getGradient(xlink.substring(1));
        }
        SVGGradient svgGradient = SVGGradient.parse(linearGradient, Float.parseFloat(this.svgWidth), Float.parseFloat(this.svgHeight), fallback);
        this.gradients.put(svgGradient.getId(), svgGradient);
    }

    private void parseStyle(SVGOMStyleElement styleElement) {
        String styleString = styleElement.getTextContent();
        Pattern patt = Pattern.compile("(\\..*?)\\{(.*?)\\}");
        Matcher m = patt.matcher(styleString);
        while (m.find()) {
            String[] keys;
            String[] stringArray = keys = m.group(1).split(",");
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                key = key.substring(1);
                String value = m.group(2);
                if (this.classes.containsKey(key)) {
                    value = String.valueOf(this.classes.get(key)) + value;
                }
                this.classes.put(key, value);
                ++n2;
            }
        }
    }

    private void parseClipPath(SVGOMClipPathElement clipPathElement) {
        String id = clipPathElement.getAttribute(SVG_CLIPPATH_ID_ATTRIBUTE_NAME);
        NodeList list = clipPathElement.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (1 == node.getNodeType()) {
                Element element = (Element)node;
                String elementName = element.getNodeName();
                if (SVG_PATH_ELEMENT_NAME.equals(elementName)) {
                    String d = element.getAttribute(SVG_PATH_D_ATTRIBUTE_NAME);
                    id = "url(#" + id + ")";
                    this.clipPaths.put(id, d);
                } else {
                    Logger.logWarnString(String.format(SVG_UNSUPPORTED_ERROR, "XML element in <clipPath>", elementName));
                }
            }
            ++i;
        }
    }

    private void parseSVGSize(SVGDocument doc) {
        String[] unsupported_units;
        float percent;
        float newHeight;
        float newWidth;
        SVGSVGElement el = doc.getRootElement();
        String width = el.getAttributeNS(null, "width");
        String height = el.getAttributeNS(null, "height");
        String viewbox = el.getAttributeNS(null, "viewBox");
        String[] viewboxFields = viewbox.split(" ");
        if (width.isEmpty()) {
            newWidth = Float.parseFloat(viewboxFields[2]) - Float.parseFloat(viewboxFields[0]);
            el.setAttribute("width", String.valueOf(newWidth));
        }
        if (height.isEmpty()) {
            newHeight = Float.parseFloat(viewboxFields[3]) - Float.parseFloat(viewboxFields[1]);
            el.setAttribute("height", String.valueOf(newHeight));
        }
        if (width.contains("%")) {
            newWidth = Float.parseFloat(viewboxFields[2]) - Float.parseFloat(viewboxFields[0]);
            percent = Float.parseFloat(width.replace("%", ""));
            newWidth = newWidth * percent / 100.0f;
            el.setAttribute("width", String.valueOf(newWidth));
        }
        if (height.contains("%")) {
            newHeight = Float.parseFloat(viewboxFields[3]) - Float.parseFloat(viewboxFields[1]);
            percent = Float.parseFloat(height.replace("%", ""));
            newHeight = newHeight * percent / 100.0f;
            el.setAttribute("height", String.valueOf(newHeight));
        }
        String[] stringArray = unsupported_units = new String[]{"em", "ex", "pt", "pc", "cm", "mm", "in"};
        int n = unsupported_units.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            if (width.endsWith(unit) || height.endsWith(unit)) {
                Logger.logWarnString(String.format(SVG_UNSUPPORTED_ERROR, "units for svg width and height - units will be considered as pixels", unit));
                width = width.replace(unit, "");
                height = height.replace(unit, "");
                viewbox = String.format("0 0 %s %s", width, height);
                el.setAttribute("width", width);
                el.setAttribute("height", height);
                el.setAttribute("viewBox", viewbox);
            }
            ++n2;
        }
        this.svgWidth = el.getAttributeNS(null, "width").replace("px", "");
        this.svgHeight = el.getAttributeNS(null, "height").replace("px", "");
        viewbox = el.getAttributeNS(null, "viewBox");
        Logger.logDebugString("W:" + width + " H:" + height + " VB:" + viewbox);
    }

    @Override
    public VGGroupMaster getVGTopGroup() {
        return this.topGroup;
    }

    @Override
    public float getSVGWidth() {
        return Float.parseFloat(this.svgWidth);
    }

    @Override
    public float getSVGHeight() {
        return Float.parseFloat(this.svgHeight);
    }
}

