/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.svg;

import com.microej.converter.vectorimage.ShapeUtils;
import com.microej.converter.vectorimage.svg.SVGAnimation;
import com.microej.converter.vectorimage.svg.SVGParser;
import com.microej.converter.vectorimage.svg.SVGPath;
import com.microej.converter.vectorimage.svg.SVGStyle;
import com.microej.converter.vectorimage.vg.VGGroup;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import org.apache.batik.anim.dom.SVGOMAnimateTransformElement;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGGroup {
    private static final String SVG_ELEMENT_G = "g";
    private static final String SVG_ELEMENT_PATH = "path";
    private static final String SVG_ELEMENT_POLYGON = "polygon";
    private static final String SVG_ELEMENT_RECTANGLE = "rect";
    private static final String SVG_ELEMENT_CIRCLE = "circle";
    private static final String SVG_ELEMENT_ELLIPSE = "ellipse";
    private static final String SVG_ELEMENT_TEXT = "text";
    private static final String SVG_ELEMENT_POLYLINE = "polyline";
    private static final String SVG_ELEMENT_LINE = "line";
    private static final String SVG_LINEAR_GRADIENT_ELEMENT_NAME = "linearGradient";
    private static final String SVG_CLIPPATH_ATTRIBUTE_NAME = "clip-path";
    ArrayList<Object> children = new ArrayList();
    ArrayList<SVGAnimation> animateTransform = new ArrayList();
    SVGStyle vgStyle;
    Shape clip = null;
    AffineTransform at = null;

    public SVGGroup(SVGParser svgParser, Element group, SVGStyle vgStyle) {
        this.vgStyle = new SVGStyle(svgParser, vgStyle);
        this.vgStyle.updateStyle(group);
        String clipPathId = group.getAttribute(SVG_CLIPPATH_ATTRIBUTE_NAME);
        String clipPath = svgParser.getClipPath(clipPathId);
        if (clipPath != null) {
            this.clip = ShapeUtils.getPathShape(clipPath);
        }
        GraphicsNode gvtNode = SVGParser.ctx.getGraphicsNode(group);
        this.at = gvtNode.getGlobalTransform();
        NodeList list = group.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            block31: {
                String elementName;
                Node node = list.item(i);
                if (1 != node.getNodeType() || node == null) break block31;
                Element element = (Element)node;
                switch (elementName = element.getNodeName()) {
                    case "g": {
                        this.children.add(new SVGGroup(svgParser, element, this.vgStyle));
                        break;
                    }
                    case "ellipse": 
                    case "circle": 
                    case "polygon": 
                    case "line": 
                    case "path": 
                    case "rect": 
                    case "text": 
                    case "polyline": {
                        this.children.add(new SVGPath(svgParser, element, this.vgStyle));
                        break;
                    }
                    case "linearGradient": {
                        svgParser.parseLinearGradient(element);
                        break;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < group.getChildNodes().getLength()) {
            if (group.getChildNodes().item(i) instanceof SVGOMAnimateTransformElement) {
                this.animateTransform.add(new SVGAnimation((SVGOMAnimateTransformElement)group.getChildNodes().item(i)));
            }
            ++i;
        }
    }

    public int computePaths(VGGroup parent, int pathId, ArrayList<SVGAnimation> animateTransform, Shape parentClip) {
        animateTransform.addAll(this.animateTransform);
        this.clip = this.at.createTransformedShape(this.clip);
        Shape localClip = ShapeUtils.clipShape(this.clip, parentClip);
        VGGroup vgGroup = new VGGroup(null);
        parent.addChild(vgGroup);
        for (Object child : this.children) {
            pathId = child instanceof SVGGroup ? ((SVGGroup)child).computePaths(vgGroup, pathId, animateTransform, localClip) : ((SVGPath)child).computePaths(vgGroup, pathId, animateTransform, localClip);
        }
        return pathId;
    }
}

