/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.svg;

import com.microej.converter.vectorimage.XmlUtils;
import com.microej.converter.vectorimage.vg.VGColor;
import com.microej.converter.vectorimage.vg.VGGradientStop;
import org.w3c.dom.Element;

public class SVGGradientStop {
    private static final String SVG_ATTRIBUTE_STYLE = "style";
    private static final String SVG_ATTRIBUTE_OFFSET = "offset";
    private static final String SVG_ATTRIBUTE_STOP_COLOR = "stop-color";
    private static final String SVG_ATTRIBUTE_STOP_OPACITY = "stop-opacity";
    private final float offset;
    private final String color;
    private final float opacity;

    public static SVGGradientStop parse(Element stop, String currentColor) {
        String sOffset = XmlUtils.getAttribute(stop, "", SVG_ATTRIBUTE_OFFSET);
        float offset = sOffset.isEmpty() ? 1.0f : XmlUtils.percentCheckAttribute(sOffset, 1.0f);
        String style = XmlUtils.getAttribute(stop, "", SVG_ATTRIBUTE_STYLE);
        String color = XmlUtils.getAttribute(stop, "", SVG_ATTRIBUTE_STOP_COLOR);
        color = color.equals("currentColor") ? currentColor : XmlUtils.parseStyle(style, color, SVG_ATTRIBUTE_STOP_COLOR);
        float opacity = XmlUtils.getAttribute(stop, 1.0f, SVG_ATTRIBUTE_STOP_OPACITY);
        opacity = XmlUtils.parseStyle(style, opacity, SVG_ATTRIBUTE_STOP_OPACITY);
        return new SVGGradientStop(color, offset, opacity);
    }

    public SVGGradientStop(String color, float offset, float opacity) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.offset = offset;
        this.color = color;
        this.opacity = opacity;
    }

    public VGGradientStop toVG() {
        VGGradientStop stop = new VGGradientStop(VGColor.createColor(this.color));
        stop.setOffset(this.offset);
        stop.setOpacity(this.opacity);
        return stop;
    }

    public String getColor() {
        return this.color;
    }

    public float getOpacity() {
        return this.opacity;
    }
}

