/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.svg;

import com.microej.converter.vectorimage.XmlUtils;
import com.microej.converter.vectorimage.svg.SVGAffineTransformParser;
import com.microej.converter.vectorimage.svg.SVGGradientStop;
import com.microej.converter.vectorimage.vg.VGGradient;
import ej.microvg.image.LinearGradient;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGGradient {
    private static final String SVG_ATTRIBUTE_ID = "id";
    private static final String SVG_ATTRIBUTE_X1 = "x1";
    private static final String SVG_ATTRIBUTE_Y1 = "y1";
    private static final String SVG_ATTRIBUTE_X2 = "x2";
    private static final String SVG_ATTRIBUTE_Y2 = "y2";
    private static final String SVG_ATTRIBUTE_COLOR = "color";
    private static final String SVG_ATTRIBUTE_GRADIENTUNITS = "gradientUnits";
    private static final String SVG_ATTRIBUTE_GRADIENTTRANSFORM = "gradientTransform";
    private static final String SVG_ELEMENT_STOP = "stop";
    private static final String SVG_GRADIENTUNITS_USERSPACEONUSE = "userSpaceOnUse";
    private static final String SVG_GRADIENTUNITS_OBJECTBOUNDINGBOX = "objectBoundingBox";
    private final String id;
    private final Rectangle2D.Float bounds;
    private final String gradientUnits;
    private AffineTransform transform;
    private final List<SVGGradientStop> stops;

    public static SVGGradient parse(Element linearGradient, float width, float height, SVGGradient fallback) {
        String id = XmlUtils.getAttribute(linearGradient, "NoId", SVG_ATTRIBUTE_ID);
        String gradientUnits = XmlUtils.getAttribute(linearGradient, SVG_GRADIENTUNITS_OBJECTBOUNDINGBOX, SVG_ATTRIBUTE_GRADIENTUNITS);
        AffineTransform transform = SVGGradient.parseTransform(linearGradient, fallback != null ? fallback.transform : new AffineTransform());
        List<SVGGradientStop> stops = SVGGradient.parseStops(linearGradient, fallback != null ? fallback.stops : new ArrayList<SVGGradientStop>());
        Rectangle2D.Float bounds = fallback != null ? fallback.bounds : new Rectangle2D.Float();
        float startX = SVGGradient.parseBound(linearGradient, SVG_ATTRIBUTE_X1, width, (float)bounds.getMinX());
        float startY = SVGGradient.parseBound(linearGradient, SVG_ATTRIBUTE_Y1, height, (float)bounds.getMinY());
        float endX = SVGGradient.parseBound(linearGradient, SVG_ATTRIBUTE_X2, width, (float)bounds.getMaxX());
        float endY = SVGGradient.parseBound(linearGradient, SVG_ATTRIBUTE_Y2, height, (float)bounds.getMaxY());
        bounds = new Rectangle2D.Float(startX, startY, endX - startX, endY - startY);
        return SVGGradient.create(id, gradientUnits, bounds, stops, transform);
    }

    private static List<SVGGradientStop> parseStops(Element linearGradient, List<SVGGradientStop> fallback) {
        NodeList list = linearGradient.getChildNodes();
        ArrayList<SVGGradientStop> stops = new ArrayList<SVGGradientStop>();
        int i = 0;
        while (i < list.getLength()) {
            Element element;
            String elementName;
            Node node = list.item(i);
            if (1 == node.getNodeType() && SVG_ELEMENT_STOP == (elementName = (element = (Element)node).getNodeName())) {
                String color = XmlUtils.getAttribute(linearGradient, "black", SVG_ATTRIBUTE_COLOR);
                stops.add(SVGGradientStop.parse(element, color));
            }
            ++i;
        }
        if (stops.isEmpty() && !fallback.isEmpty()) {
            stops.addAll(fallback);
        }
        return stops;
    }

    private static AffineTransform parseTransform(Element linearGradient, AffineTransform fallback) {
        String s = XmlUtils.getAttribute(linearGradient, "", SVG_ATTRIBUTE_GRADIENTTRANSFORM);
        return s.isEmpty() ? fallback : SVGAffineTransformParser.getAffineTransform(s);
    }

    private static float parseBound(Element element, String attributeName, float size, float fallback) {
        String s = XmlUtils.getAttribute(element, "", attributeName);
        return s.isEmpty() ? fallback : XmlUtils.percentCheckAttribute(s, size);
    }

    public static SVGGradient create(String id, String units, Rectangle2D.Float bounds, List<SVGGradientStop> stops, AffineTransform transform) {
        return new SVGGradient(id, units, bounds, stops, transform);
    }

    public SVGGradient(SVGGradient other) {
        this(other.id, other.gradientUnits, other.bounds, other.stops, other.transform);
    }

    private SVGGradient(String id, String gradientUnits, Rectangle2D.Float bounds, List<SVGGradientStop> stops, AffineTransform transform) {
        this.id = id;
        this.gradientUnits = gradientUnits;
        this.bounds = bounds;
        this.stops = stops;
        this.transform = transform;
    }

    public String getId() {
        return this.id;
    }

    public List<SVGGradientStop> getStops() {
        return this.stops;
    }

    public void setStops(List<SVGGradientStop> stops) {
        for (SVGGradientStop stop : stops) {
            this.stops.add(stop);
        }
    }

    public void setTransform(AffineTransform transform) {
        this.transform.setTransform(transform);
    }

    public void addTransform(AffineTransform transform) {
        AffineTransform at = new AffineTransform();
        at.concatenate(transform);
        if (this.transform != null) {
            at.concatenate(this.transform);
        }
        this.transform = at;
    }

    public void addTransform(String transform) {
        this.addTransform(SVGAffineTransformParser.getAffineTransform(transform));
    }

    public VGGradient toVG() {
        VGGradient gradient = new VGGradient();
        gradient.setX1((float)this.bounds.getX());
        gradient.setY1((float)this.bounds.getY());
        gradient.setX2((float)this.bounds.getMaxX());
        gradient.setY2((float)this.bounds.getMaxY());
        LinearGradient.LinearGradientStop[] lgStops = new LinearGradient.LinearGradientStop[this.stops.size()];
        int i = 0;
        while (i < this.stops.size()) {
            lgStops[i] = this.stops.get(i).toVG();
            ++i;
        }
        gradient.setStops(lgStops);
        switch (this.gradientUnits) {
            case "userSpaceOnUse": {
                gradient.setGradientUnits(VGGradient.GradientUnit.USERSPACEONUSE);
                break;
            }
            case "objectBoundingBox": {
                gradient.setGradientUnits(VGGradient.GradientUnit.OBJECTBOUNDINGBOX);
                break;
            }
            default: {
                gradient.setGradientUnits(VGGradient.GradientUnit.UNKNOWN);
            }
        }
        gradient.setTransform(this.transform);
        return gradient;
    }
}

