/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.svg;

import com.microej.converter.vectorimage.XmlUtils;
import com.microej.converter.vectorimage.vg.VGAnimation;
import com.microej.converter.vectorimage.vg.VGRotateAnimation;
import com.microej.converter.vectorimage.vg.VGScaleAnimation;
import com.microej.converter.vectorimage.vg.VGTranslateAnimation;
import org.apache.batik.anim.dom.SVGOMAnimateTransformElement;
import org.w3c.dom.Element;

public class SVGAnimation {
    public static final String SVG_ATTRIBUTE_TYPE = "type";
    public static final String SVG_ATTRIBUTE_DUR = "dur";
    public static final String SVG_ATTRIBUTE_BEGIN = "begin";
    public static final String SVG_ATTRIBUTE_FROM = "from";
    public static final String SVG_ATTRIBUTE_TO = "to";
    public static final String SVG_ATTRIBUTE_FILL = "fill";
    public static final String SVG_ATTRIBUTE_FILL_FREEZE = "freeze";
    public static final String SVG_ANIMATION_TYPE_TRANSLATE = "translate";
    public static final String SVG_ANIMATION_TYPE_ROTATE = "rotate";
    public static final String SVG_ANIMATION_TYPE_SCALE = "scale";
    private String type = "None";
    private String sDuration = "0s";
    private String sBegin = "0s";
    private float duration = 0.0f;
    private float begin = 0.0f;
    private String from = "";
    private String to = "";
    private String fill = "freeze";
    private int keepDuration = 0;
    private float translationX = 0.0f;
    private float translationY = 0.0f;
    private float startX = 0.0f;
    private float startY = 0.0f;
    private float startAngle = 0.0f;
    private float rotationAngle = 0.0f;
    private float startRotationCenterX = 0.0f;
    private float startRotationCenterY = 0.0f;
    private float rotationTranslationCenterX = 0.0f;
    private float rotationTranslationCenterY = 0.0f;
    private final String interpolatorPathData = "M 0,0 L 1,1";

    public SVGAnimation(SVGOMAnimateTransformElement item) {
        this.type = XmlUtils.getAttribute((Element)item, this.type, SVG_ATTRIBUTE_TYPE);
        this.sDuration = XmlUtils.getAttribute((Element)item, this.sDuration, SVG_ATTRIBUTE_DUR);
        this.sBegin = XmlUtils.getAttribute((Element)item, this.sBegin, SVG_ATTRIBUTE_BEGIN);
        this.from = XmlUtils.getAttribute((Element)item, this.from, SVG_ATTRIBUTE_FROM);
        this.to = XmlUtils.getAttribute((Element)item, this.to, SVG_ATTRIBUTE_TO);
        this.fill = XmlUtils.getAttribute((Element)item, this.fill, SVG_ATTRIBUTE_FILL);
        this.duration = Float.parseFloat(this.sDuration.replace("s", "")) * 1000.0f;
        this.begin = Float.parseFloat(this.sBegin.replace("s", "")) * 1000.0f;
        if (this.fill.equals(SVG_ATTRIBUTE_FILL_FREEZE)) {
            this.keepDuration = -1;
        }
        switch (this.type) {
            case "translate": {
                this.translationX = this.parseXTranslate(this.from, this.to);
                this.translationY = this.parseYTranslate(this.from, this.to);
                this.startX = this.parseXStart(this.from);
                this.startY = this.parseYStart(this.from);
                break;
            }
            case "rotate": {
                this.startAngle = this.parseRotate(this.from, this.to, "startAngle");
                this.rotationAngle = this.parseRotate(this.from, this.to, "rotationAngle");
                this.startRotationCenterX = this.parseRotate(this.from, this.to, "startRotationCenterX");
                this.startRotationCenterY = this.parseRotate(this.from, this.to, "startRotationCenterY");
                this.rotationTranslationCenterX = this.parseRotate(this.from, this.to, "rotationTranslationCenterX");
                this.rotationTranslationCenterY = this.parseRotate(this.from, this.to, "rotationTranslationCenterY");
            }
        }
    }

    public VGAnimation toVG() {
        switch (this.type) {
            case "translate": {
                return new VGTranslateAnimation((int)this.duration, (int)this.begin, this.keepDuration, "M 0,0 L 1,1", this.translationX, this.translationY, this.startX, this.startY);
            }
            case "scale": {
                return new VGScaleAnimation((int)this.duration, (int)this.begin, this.keepDuration, "M 0,0 L 1,1", Float.parseFloat(this.from), Float.parseFloat(this.to), Float.parseFloat(this.from), Float.parseFloat(this.to), 0.0f, 0.0f);
            }
            case "rotate": {
                return new VGRotateAnimation((int)this.duration, (int)this.begin, this.keepDuration, "M 0,0 L 1,1", this.startAngle, this.rotationAngle, this.startRotationCenterX, this.startRotationCenterY, this.rotationTranslationCenterX, this.rotationTranslationCenterY);
            }
        }
        return null;
    }

    private float parseRotate(String from, String to, String attr) {
        String[] arrayFrom = from.split(" ");
        String[] arrayTo = to.split(" ");
        float startAngle = Float.parseFloat(from.split(" ")[0]);
        float rotationAngle = Float.parseFloat(to.split(" ")[0]) - Float.parseFloat(arrayFrom[0]);
        float startRotationCenterX = arrayFrom.length <= 1 ? 0.0f : Float.parseFloat(arrayFrom[1]);
        float startRotationCenterY = arrayFrom.length <= 2 ? 0.0f : Float.parseFloat(arrayFrom[2]);
        float rotationTranslationCenterX = arrayTo.length <= 1 ? -startRotationCenterX : Float.parseFloat(arrayTo[1]) - startRotationCenterX;
        float rotationTranslationCenterY = arrayTo.length <= 2 ? -startRotationCenterY : Float.parseFloat(arrayTo[2]) - startRotationCenterY;
        switch (attr) {
            case "startAngle": {
                return startAngle;
            }
            case "rotationAngle": {
                return rotationAngle;
            }
            case "startRotationCenterX": {
                return startRotationCenterX;
            }
            case "startRotationCenterY": {
                return startRotationCenterY;
            }
            case "rotationTranslationCenterX": {
                return rotationTranslationCenterX;
            }
            case "rotationTranslationCenterY": {
                return rotationTranslationCenterY;
            }
        }
        return 0.0f;
    }

    private float parseXTranslate(String from, String to) {
        return Float.parseFloat(to.split(" ")[0]) - Float.parseFloat(from.split(" ")[0]);
    }

    private float parseYTranslate(String from, String to) {
        String[] arrayFrom = from.split(" ");
        String[] arrayTo = to.split(" ");
        from = arrayFrom.length <= 1 ? "0" : arrayFrom[1];
        to = arrayTo.length <= 1 ? "0" : arrayTo[1];
        return Float.parseFloat(to) - Float.parseFloat(from);
    }

    private float parseXStart(String from) {
        return Float.parseFloat(from.split(" ")[0]);
    }

    private float parseYStart(String from) {
        String[] array = from.split(" ");
        if (array.length <= 1) {
            return 0.0f;
        }
        return Float.parseFloat(array[1]);
    }
}

