/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator.raw.model;

import com.microej.converter.vectorimage.generator.raw.PathBufferEncoder;
import com.microej.converter.vectorimage.generator.raw.model.AbstractCommand;
import com.microej.converter.vectorimage.generator.raw.model.Point;
import ej.microvg.image.ImageGenerator;
import ej.microvg.image.Path;
import ej.microvg.image.pathdata.PathData;
import java.util.ArrayList;
import java.util.Iterator;

public class PathImpl
implements Path,
Iterable<AbstractCommand> {
    private final ArrayList<AbstractCommand> commands;
    private final Point current;
    private final Point topLeft;
    private final Point bottomRight;
    private final ImageGenerator generator;

    public PathImpl(ImageGenerator generator) {
        this.generator = generator;
        this.commands = new ArrayList();
        this.current = new Point(0.0, 0.0);
        this.topLeft = new Point(2.147483647E9, 2.147483647E9);
        this.bottomRight = new Point(-2.147483648E9, -2.147483648E9);
    }

    @Override
    public void encode(PathData pathData) {
        PathBufferEncoder.encode(this.generator, this, pathData);
    }

    public void add(AbstractCommand cmd) {
        this.commands.add(cmd);
        this.updateMinMax(cmd);
        cmd.updateCurrent(this.current);
    }

    @Override
    public Iterator<AbstractCommand> iterator() {
        return this.commands.iterator();
    }

    public Point getTopLeftPoint() {
        return this.topLeft;
    }

    public Point getBottomRightPoint() {
        return this.bottomRight;
    }

    @Override
    public double getMinX() {
        return this.topLeft.getX();
    }

    @Override
    public double getMaxX() {
        return this.bottomRight.getX();
    }

    @Override
    public double getMinY() {
        return this.topLeft.getY();
    }

    @Override
    public double getMaxY() {
        return this.bottomRight.getY();
    }

    private void updateMinMax(AbstractCommand cmd) {
        boolean relative = cmd.isRelative();
        for (Point vgPoint : cmd) {
            double x = vgPoint.getX();
            double y = vgPoint.getY();
            if (relative) {
                x += this.current.getX();
                y += this.current.getY();
            }
            this.topLeft.set(Math.min(this.topLeft.getX(), x), Math.min(this.topLeft.getY(), y));
            this.bottomRight.set(Math.max(this.bottomRight.getX(), x), Math.max(this.bottomRight.getY(), y));
        }
    }
}

