/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator.raw.element;

import com.microej.converter.vectorimage.generator.raw.LittleEndianDataOutputStream;
import com.microej.converter.vectorimage.generator.raw.RawUtils;
import com.microej.converter.vectorimage.generator.raw.element.RawBlock;
import com.microej.converter.vectorimage.vg.VGPathSegment;
import java.io.IOException;
import java.util.List;

public class RawPathInterpolator
extends RawBlock {
    private final short[] endTimeRatio;
    private final float[] startX;
    private final float[] startY;

    public RawPathInterpolator(List<VGPathSegment> segments, boolean xy) {
        int size = segments.size();
        short[] localEndTimeRatio = new short[size + 1];
        float[] localStartX = new float[size + 1];
        float[] localStartY = new float[size + 1];
        int segmentId = 0;
        while (segmentId < size) {
            VGPathSegment segment = segments.get(segmentId);
            localEndTimeRatio[segmentId] = segment.getEndShort();
            localStartX[segmentId] = segment.getX0();
            localStartY[segmentId] = segment.getY0();
            ++segmentId;
        }
        VGPathSegment segment = segments.get(size - 1);
        localEndTimeRatio[size] = segment.getEndShort();
        localStartX[size] = segment.getX1();
        localStartY[size] = segment.getY1();
        this.endTimeRatio = localEndTimeRatio;
        this.startX = xy ? localStartX : localStartY;
        this.startY = xy ? localStartY : new float[]{};
    }

    @Override
    public int getEncodedSize() {
        return 4 + RawUtils.align32(this.endTimeRatio.length * 2) + 4 * this.startX.length + 4 * this.startY.length;
    }

    @Override
    public void encode(LittleEndianDataOutputStream buffer) throws IOException {
        super.encode(buffer);
        buffer.writeInt(this.endTimeRatio.length);
        Object[] objectArray = this.endTimeRatio;
        int n = this.endTimeRatio.length;
        int n2 = 0;
        while (n2 < n) {
            short s = objectArray[n2];
            buffer.writeShort(s);
            ++n2;
        }
        RawUtils.addPadding(buffer);
        objectArray = this.startX;
        n = this.startX.length;
        n2 = 0;
        while (n2 < n) {
            short s = objectArray[n2];
            buffer.writeFloat(s);
            ++n2;
        }
        objectArray = this.startY;
        n = this.startY.length;
        n2 = 0;
        while (n2 < n) {
            short s = objectArray[n2];
            buffer.writeFloat(s);
            ++n2;
        }
    }
}

