/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator.raw.element;

import com.microej.converter.vectorimage.generator.raw.LittleEndianDataOutputStream;
import com.microej.converter.vectorimage.generator.raw.RawGenerator;
import com.microej.converter.vectorimage.generator.raw.element.RawAnimation;
import com.microej.converter.vectorimage.generator.raw.element.RawAnimationHandler;
import com.microej.converter.vectorimage.generator.raw.element.RawGradient;
import com.microej.converter.vectorimage.generator.raw.element.RawPathData;
import com.microej.converter.vectorimage.generator.raw.element.RawPathGradient;
import com.microej.converter.vectorimage.vg.VGPathGradient;
import java.io.IOException;
import java.util.ArrayList;

public class RawPathGradientAnimate
extends RawPathGradient
implements RawAnimationHandler {
    private final ArrayList<RawAnimation> rawAlphaAnimations = new ArrayList();
    private final ArrayList<RawAnimation> rawPathDataAnimations = new ArrayList();

    public RawPathGradientAnimate(VGPathGradient path, RawPathData pathData, RawGradient gradient, RawGenerator printer) {
        super(path, pathData, gradient, printer);
    }

    @Override
    protected byte getKind() {
        return 7;
    }

    @Override
    public int getDuration() {
        int duration = 0;
        duration = Math.max(duration, this.getDuration(this.rawAlphaAnimations));
        duration = Math.max(duration, this.getDuration(this.rawPathDataAnimations));
        return duration;
    }

    @Override
    public int getEncodedSize() {
        return super.getEncodedSize() + 4 + this.getEncodedSize(this.rawAlphaAnimations) + this.getEncodedSize(this.rawPathDataAnimations);
    }

    @Override
    public void encode(LittleEndianDataOutputStream buffer) throws IOException {
        super.encode(buffer);
        buffer.writeByte(this.rawAlphaAnimations.size());
        buffer.writeByte(this.rawPathDataAnimations.size());
        this.encodeBlockSize(buffer);
        RawPathGradientAnimate.debugUpdateBlockShift(true);
        this.encode(buffer, this.rawAlphaAnimations);
        this.encode(buffer, this.rawPathDataAnimations);
        RawPathGradientAnimate.debugUpdateBlockShift(false);
    }

    @Override
    public void setTranslate(RawAnimation raw) {
        throw new IllegalArgumentException("unexpected animation on a gradient: translate");
    }

    @Override
    public void setTranslateXY(RawAnimation raw) {
        throw new IllegalArgumentException("unexpected animation on a gradient: translateXY");
    }

    @Override
    public void setScale(RawAnimation raw) {
        throw new IllegalArgumentException("unexpected animation on a gradient: scale");
    }

    @Override
    public void setRotate(RawAnimation raw) {
        throw new IllegalArgumentException("unexpected animation on a gradient: rotate");
    }

    @Override
    public void setAlpha(RawAnimation raw) {
        this.rawAlphaAnimations.add(raw);
    }

    @Override
    public void setColor(RawAnimation raw) {
        throw new IllegalArgumentException("unexpected animation on a gradient: color");
    }

    @Override
    public void setPathData(RawAnimation raw) {
        this.rawPathDataAnimations.add(raw);
    }
}

