/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator.raw.element;

import com.microej.converter.vectorimage.generator.raw.LittleEndianDataOutputStream;
import com.microej.converter.vectorimage.generator.raw.RawGenerator;
import com.microej.converter.vectorimage.generator.raw.RawUtils;
import com.microej.converter.vectorimage.generator.raw.element.RawAnimation;
import com.microej.converter.vectorimage.generator.raw.element.RawAnimationHandler;
import com.microej.converter.vectorimage.generator.raw.element.RawPathColor;
import com.microej.converter.vectorimage.generator.raw.element.RawPathData;
import com.microej.converter.vectorimage.vg.VGPathColor;
import java.io.IOException;
import java.util.ArrayList;

public class RawPathColorAnimate
extends RawPathColor
implements RawAnimationHandler {
    private final ArrayList<RawAnimation> rawColorAnimations = new ArrayList();
    private final ArrayList<RawAnimation> rawAlphaAnimations = new ArrayList();
    private final ArrayList<RawAnimation> rawPathDataAnimations = new ArrayList();

    public RawPathColorAnimate(VGPathColor p, RawPathData pathData, RawGenerator printer) {
        super(p, pathData, printer);
    }

    @Override
    protected byte getKind() {
        return 6;
    }

    @Override
    public int getDuration() {
        int duration = 0;
        duration = Math.max(duration, this.getDuration(this.rawColorAnimations));
        duration = Math.max(duration, this.getDuration(this.rawAlphaAnimations));
        duration = Math.max(duration, this.getDuration(this.rawPathDataAnimations));
        return duration;
    }

    @Override
    public int getEncodedSize() {
        return super.getEncodedSize() + 8 + this.getEncodedSize(this.rawColorAnimations) + this.getEncodedSize(this.rawAlphaAnimations) + this.getEncodedSize(this.rawPathDataAnimations);
    }

    @Override
    public void encode(LittleEndianDataOutputStream buffer) throws IOException {
        super.encode(buffer);
        buffer.writeByte(this.rawColorAnimations.size());
        buffer.writeByte(this.rawAlphaAnimations.size());
        buffer.writeByte(this.rawPathDataAnimations.size());
        buffer.writeByte(0);
        this.encodeBlockSize(buffer);
        RawUtils.addPadding(buffer);
        RawPathColorAnimate.debugUpdateBlockShift(true);
        this.encode(buffer, this.rawColorAnimations);
        this.encode(buffer, this.rawAlphaAnimations);
        this.encode(buffer, this.rawPathDataAnimations);
        RawPathColorAnimate.debugUpdateBlockShift(false);
    }

    @Override
    public void setTranslate(RawAnimation raw) {
        throw new IllegalArgumentException("unexpected animation on a path: translate");
    }

    @Override
    public void setTranslateXY(RawAnimation raw) {
        throw new IllegalArgumentException("unexpected animation on a path: translateXY");
    }

    @Override
    public void setScale(RawAnimation raw) {
        throw new IllegalArgumentException("unexpected animation on a path: scale");
    }

    @Override
    public void setRotate(RawAnimation raw) {
        throw new IllegalArgumentException("unexpected animation on a path: rotate");
    }

    @Override
    public void setAlpha(RawAnimation raw) {
        this.rawAlphaAnimations.add(raw);
    }

    @Override
    public void setColor(RawAnimation raw) {
        this.rawColorAnimations.add(raw);
    }

    @Override
    public void setPathData(RawAnimation raw) {
        this.rawPathDataAnimations.add(raw);
    }
}

