/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator.raw.element;

import com.microej.converter.vectorimage.generator.raw.LittleEndianDataOutputStream;
import com.microej.converter.vectorimage.generator.raw.RawUtils;
import com.microej.converter.vectorimage.generator.raw.element.RawQueueBlock;
import com.microej.converter.vectorimage.vg.VGGroupTransform;
import java.awt.geom.AffineTransform;
import java.io.IOException;

public class RawGroupTransform
extends RawQueueBlock {
    private static final int SIZE_MATRIX = 36;
    private final VGGroupTransform transform;

    public RawGroupTransform(VGGroupTransform transform) {
        this.transform = transform;
    }

    @Override
    protected byte getKind() {
        return 3;
    }

    @Override
    public int getEncodedSize() {
        return super.getEncodedSize() + RawUtils.getPadding(super.getEncodedSize()) + 36;
    }

    @Override
    public void encode(LittleEndianDataOutputStream buffer) throws IOException {
        super.encode(buffer);
        RawUtils.addPadding(buffer);
        RawGroupTransform.debugUpdateBlockShift(true);
        AffineTransform at = this.transform.getTransformation();
        buffer.writeFloat((float)at.getScaleX());
        buffer.writeFloat((float)at.getShearX());
        buffer.writeFloat((float)at.getTranslateX());
        buffer.writeFloat((float)at.getShearY());
        buffer.writeFloat((float)at.getScaleY());
        buffer.writeFloat((float)at.getTranslateY());
        buffer.writeFloat(0.0f);
        buffer.writeFloat(0.0f);
        buffer.writeFloat(1.0f);
    }
}

