/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator.raw.element;

import com.microej.converter.vectorimage.generator.raw.LittleEndianDataOutputStream;
import com.microej.converter.vectorimage.generator.raw.element.RawAnimation;
import com.microej.converter.vectorimage.generator.raw.element.RawAnimationHandler;
import com.microej.converter.vectorimage.generator.raw.element.RawQueueBlock;
import com.microej.converter.vectorimage.vg.VGGroupAnimate;
import java.io.IOException;
import java.util.ArrayList;

public class RawGroupAnimate
extends RawQueueBlock
implements RawAnimationHandler {
    private final VGGroupAnimate animationData;
    private final ArrayList<RawAnimation> rawScaleAnimations;
    private final ArrayList<RawAnimation> rawRotateAnimations;
    private final ArrayList<RawAnimation> rawTranslateXAnimations;
    private final ArrayList<RawAnimation> rawTranslateXYAnimations;

    public RawGroupAnimate(VGGroupAnimate animationData) {
        this.animationData = animationData;
        this.rawScaleAnimations = new ArrayList();
        this.rawRotateAnimations = new ArrayList();
        this.rawTranslateXAnimations = new ArrayList();
        this.rawTranslateXYAnimations = new ArrayList();
    }

    @Override
    public int getDuration() {
        int duration = 0;
        duration = Math.max(duration, this.getDuration(this.rawRotateAnimations));
        duration = Math.max(duration, this.getDuration(this.rawScaleAnimations));
        duration = Math.max(duration, this.getDuration(this.rawTranslateXAnimations));
        duration = Math.max(duration, this.getDuration(this.rawTranslateXYAnimations));
        return duration;
    }

    @Override
    protected byte getKind() {
        return 4;
    }

    @Override
    public int getEncodedSize() {
        int sizeTranslateX = this.getEncodedSize(this.rawTranslateXAnimations);
        int sizeTranslateXY = this.getEncodedSize(this.rawTranslateXYAnimations);
        if (sizeTranslateX != 0 && sizeTranslateXY != 0) {
            throw new IllegalArgumentException("an animation can only hold a set of translation or a set of translationXY");
        }
        return super.getEncodedSize() + 1 + 2 + 32 + this.getEncodedSize(this.rawScaleAnimations) + this.getEncodedSize(this.rawRotateAnimations) + sizeTranslateX + sizeTranslateXY;
    }

    @Override
    public void setTranslate(RawAnimation raw) {
        this.rawTranslateXAnimations.add(raw);
    }

    @Override
    public void setTranslateXY(RawAnimation raw) {
        this.rawTranslateXYAnimations.add(raw);
    }

    @Override
    public void setScale(RawAnimation raw) {
        this.rawScaleAnimations.add(raw);
    }

    @Override
    public void setRotate(RawAnimation raw) {
        this.rawRotateAnimations.add(raw);
    }

    @Override
    public void setAlpha(RawAnimation animation) {
        throw new IllegalArgumentException("unexpected animation on a group: alpha");
    }

    @Override
    public void setColor(RawAnimation animation) {
        throw new IllegalArgumentException("unexpected animation on a group: color");
    }

    @Override
    public void setPathData(RawAnimation animation) {
        throw new IllegalArgumentException("unexpected animation on a group: path data");
    }

    @Override
    public void encode(LittleEndianDataOutputStream buffer) throws IOException {
        super.encode(buffer);
        RawGroupAnimate.debugUpdateBlockShift(true);
        buffer.writeByte(0);
        this.encodeBlockSize(buffer);
        buffer.writeByte(this.rawTranslateXAnimations.size());
        buffer.writeByte(this.rawTranslateXYAnimations.size());
        buffer.writeByte(this.rawRotateAnimations.size());
        buffer.writeByte(this.rawScaleAnimations.size());
        buffer.writeFloat(this.animationData.getScaleX());
        buffer.writeFloat(this.animationData.getScaleY());
        buffer.writeFloat(this.animationData.getTranslateX());
        buffer.writeFloat(this.animationData.getTranslateY());
        buffer.writeFloat(this.animationData.getPivotX());
        buffer.writeFloat(this.animationData.getPivotY());
        buffer.writeFloat(this.animationData.getRotation());
        this.encode(buffer, this.rawTranslateXAnimations);
        this.encode(buffer, this.rawTranslateXYAnimations);
        this.encode(buffer, this.rawRotateAnimations);
        this.encode(buffer, this.rawScaleAnimations);
    }
}

