/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator.raw.element;

import com.microej.converter.vectorimage.Logger;
import com.microej.converter.vectorimage.generator.raw.LittleEndianDataOutputStream;
import java.io.IOException;

public abstract class RawBlock {
    private int offset;
    private static String debugGroupShift = "\t";

    public abstract int getEncodedSize();

    public void encode(LittleEndianDataOutputStream buffer) throws IOException {
        this.offset = buffer.getOffset();
        if (Logger.logEnabled(3)) {
            Logger.logDebugString("[0x" + Integer.toHexString(this.offset) + "]" + debugGroupShift + this.getClass().getSimpleName());
        }
    }

    public int getOffset() {
        return this.offset;
    }

    protected static void debugUpdateBlockShift(boolean inc) {
        debugGroupShift = inc ? String.valueOf(debugGroupShift) + '\t' : debugGroupShift.substring(0, debugGroupShift.length() - 1);
    }
}

