/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator.raw.element;

import com.microej.converter.vectorimage.generator.raw.LittleEndianDataOutputStream;
import com.microej.converter.vectorimage.generator.raw.element.RawAnimation;
import com.microej.converter.vectorimage.vg.VGAnimation;
import java.io.IOException;
import java.util.ArrayList;

public interface RawAnimationHandler {
    public void setTranslate(RawAnimation var1);

    public void setTranslateXY(RawAnimation var1);

    public void setScale(RawAnimation var1);

    public void setRotate(RawAnimation var1);

    public void setAlpha(RawAnimation var1);

    public void setColor(RawAnimation var1);

    public void setPathData(RawAnimation var1);

    public int getDuration();

    default public int getDuration(ArrayList<RawAnimation> animations) {
        int duration = 0;
        for (RawAnimation rawAnimation : animations) {
            VGAnimation animation = rawAnimation.animation;
            duration = Math.max(duration, animation.getDuration() + animation.getStartOffset());
        }
        return duration;
    }

    default public int getEncodedSize(ArrayList<RawAnimation> animations) {
        int size = 0;
        for (RawAnimation rawAnimation : animations) {
            size += rawAnimation.getEncodedSize();
        }
        return size;
    }

    default public void encode(LittleEndianDataOutputStream buffer, ArrayList<RawAnimation> animations) throws IOException {
        for (RawAnimation rawAnimation : animations) {
            rawAnimation.encode(buffer);
        }
    }
}

