/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator.raw.element;

import com.microej.converter.vectorimage.generator.raw.LittleEndianDataOutputStream;
import com.microej.converter.vectorimage.generator.raw.RawGenerator;
import com.microej.converter.vectorimage.generator.raw.RawUtils;
import com.microej.converter.vectorimage.generator.raw.element.RawBlock;
import com.microej.converter.vectorimage.generator.raw.element.RawPathData;
import com.microej.converter.vectorimage.generator.raw.element.RawPathInterpolator;
import com.microej.converter.vectorimage.vg.VGAlphaAnimation;
import com.microej.converter.vectorimage.vg.VGAnimation;
import com.microej.converter.vectorimage.vg.VGColorAnimation;
import com.microej.converter.vectorimage.vg.VGPathDataAnimation;
import com.microej.converter.vectorimage.vg.VGRotateAnimation;
import com.microej.converter.vectorimage.vg.VGScaleAnimation;
import com.microej.converter.vectorimage.vg.VGTranslateAnimation;
import com.microej.converter.vectorimage.vg.VGTranslateXYAnimation;
import java.awt.Color;
import java.io.IOException;

public abstract class RawAnimation
extends RawBlock {
    public final VGAnimation animation;
    public final RawPathInterpolator pathInterpolator;

    public RawAnimation(VGAnimation animation, RawPathInterpolator pathInterpolator) {
        this.animation = animation;
        this.pathInterpolator = pathInterpolator;
    }

    @Override
    public int getEncodedSize() {
        return 16;
    }

    @Override
    public void encode(LittleEndianDataOutputStream buffer) throws IOException {
        super.encode(buffer);
        buffer.writeInt(this.animation.getDuration());
        buffer.writeInt(this.animation.getStartOffset());
        buffer.writeInt(this.animation.getKeepDuration());
        buffer.writeInt(this.pathInterpolator.getOffset());
    }

    public static class RawAnimationAlpha
    extends RawAnimation {
        public RawAnimationAlpha(VGAlphaAnimation animation, RawPathInterpolator pathInterpolator) {
            super(animation, pathInterpolator);
        }

        @Override
        public int getEncodedSize() {
            return super.getEncodedSize() + 4;
        }

        @Override
        public void encode(LittleEndianDataOutputStream buffer) throws IOException {
            super.encode(buffer);
            VGAlphaAnimation colorAnimation = (VGAlphaAnimation)this.animation;
            buffer.writeByte(colorAnimation.getStartColor());
            buffer.writeByte(colorAnimation.getEndColor());
            RawUtils.addPadding(buffer);
        }
    }

    public static class RawAnimationColor
    extends RawAnimation {
        protected final RawGenerator printer;

        public RawAnimationColor(VGColorAnimation animation, RawPathInterpolator pathInterpolator, RawGenerator printer) {
            super(animation, pathInterpolator);
            this.printer = printer;
        }

        @Override
        public int getEncodedSize() {
            return super.getEncodedSize() + 8;
        }

        @Override
        public void encode(LittleEndianDataOutputStream buffer) throws IOException {
            super.encode(buffer);
            VGColorAnimation colorAnimation = (VGColorAnimation)this.animation;
            buffer.writeInt(this.printer.convertColor(new Color(colorAnimation.getStartColor(), true), 1.0f));
            buffer.writeInt(this.printer.convertColor(new Color(colorAnimation.getEndColor(), true), 1.0f));
        }
    }

    public static class RawAnimationPathData
    extends RawAnimation {
        private final RawPathData from;
        private final RawPathData to;

        public RawAnimationPathData(VGPathDataAnimation animation, RawPathInterpolator pathInterpolator, RawPathData from, RawPathData to) {
            super(animation, pathInterpolator);
            this.from = from;
            this.to = to;
        }

        @Override
        public int getEncodedSize() {
            return super.getEncodedSize() + 8;
        }

        @Override
        public void encode(LittleEndianDataOutputStream buffer) throws IOException {
            super.encode(buffer);
            buffer.writeInt(this.from.getOffset());
            buffer.writeInt(this.to.getOffset());
        }
    }

    public static class RawAnimationRotate
    extends RawAnimation {
        public RawAnimationRotate(VGRotateAnimation animation, RawPathInterpolator pathInterpolator) {
            super(animation, pathInterpolator);
        }

        @Override
        public int getEncodedSize() {
            return super.getEncodedSize() + 24;
        }

        @Override
        public void encode(LittleEndianDataOutputStream buffer) throws IOException {
            super.encode(buffer);
            VGRotateAnimation rotateAnimation = (VGRotateAnimation)this.animation;
            buffer.writeFloat(rotateAnimation.getStartAngle());
            buffer.writeFloat(rotateAnimation.getRotationAngle());
            buffer.writeFloat(rotateAnimation.getStartRotationCenterX());
            buffer.writeFloat(rotateAnimation.getStartRotationCenterY());
            buffer.writeFloat(rotateAnimation.getRotationTranslationCenterX());
            buffer.writeFloat(rotateAnimation.getRotationTranslationCenterY());
        }
    }

    public static class RawAnimationScale
    extends RawAnimation {
        public RawAnimationScale(VGScaleAnimation animation, RawPathInterpolator pathInterpolator) {
            super(animation, pathInterpolator);
        }

        @Override
        public int getEncodedSize() {
            return super.getEncodedSize() + 24;
        }

        @Override
        public void encode(LittleEndianDataOutputStream buffer) throws IOException {
            super.encode(buffer);
            VGScaleAnimation scaleAnimation = (VGScaleAnimation)this.animation;
            buffer.writeFloat(scaleAnimation.getScaleXFrom());
            buffer.writeFloat(scaleAnimation.getScaleXTo());
            buffer.writeFloat(scaleAnimation.getScaleYFrom());
            buffer.writeFloat(scaleAnimation.getScaleYTo());
            buffer.writeFloat(scaleAnimation.getPivotX());
            buffer.writeFloat(scaleAnimation.getPivotY());
        }
    }

    public static class RawAnimationTranslate
    extends RawAnimation {
        public RawAnimationTranslate(VGTranslateAnimation animation, RawPathInterpolator pathInterpolator) {
            super(animation, pathInterpolator);
        }

        @Override
        public int getEncodedSize() {
            return super.getEncodedSize() + 16;
        }

        @Override
        public void encode(LittleEndianDataOutputStream buffer) throws IOException {
            super.encode(buffer);
            VGTranslateAnimation translateAnimation = (VGTranslateAnimation)this.animation;
            buffer.writeFloat(translateAnimation.getStartX());
            buffer.writeFloat(translateAnimation.getStartY());
            buffer.writeFloat(translateAnimation.getTranslationX());
            buffer.writeFloat(translateAnimation.getTranslationY());
        }
    }

    public static class RawAnimationTranslateXY
    extends RawAnimation {
        private final RawPathInterpolator piTranslation;

        public RawAnimationTranslateXY(VGTranslateXYAnimation animation, RawPathInterpolator pathInterpolator, RawPathInterpolator pathTranslate) {
            super(animation, pathInterpolator);
            this.piTranslation = pathTranslate;
        }

        @Override
        public int getEncodedSize() {
            return super.getEncodedSize() + 4;
        }

        @Override
        public void encode(LittleEndianDataOutputStream buffer) throws IOException {
            super.encode(buffer);
            buffer.writeInt(this.piTranslation.getOffset());
        }
    }
}

