/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator.raw;

import com.microej.converter.vectorimage.generator.raw.LittleEndianDataOutputStream;
import com.microej.converter.vectorimage.vg.VGStyle;
import java.io.IOException;

public class RawUtils {
    public static final int SIZE_16BITS = 2;
    public static final int SIZE_32BITS = 4;

    public static int align32(int value) {
        return value + 3 & 0xFFFFFFFC;
    }

    public static int getPadding(int value) {
        return RawUtils.align32(value) - value;
    }

    public static void addPadding(LittleEndianDataOutputStream buffer) throws IOException {
        int padding = RawUtils.getPadding(buffer.getOffset());
        int p = 0;
        while (p < padding) {
            buffer.write(0);
            ++p;
        }
    }

    public static float getOpacity(VGStyle style) {
        return style.getNoFill() ? 0.0f : style.getOpacity();
    }
}

