/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator.raw;

import com.microej.converter.vectorimage.generator.AbstractGenerator;
import com.microej.converter.vectorimage.generator.raw.LittleEndianDataOutputStream;
import com.microej.converter.vectorimage.generator.raw.PathBufferParser;
import com.microej.converter.vectorimage.generator.raw.RawUtils;
import com.microej.converter.vectorimage.generator.raw.element.RawAnimation;
import com.microej.converter.vectorimage.generator.raw.element.RawAnimationHandler;
import com.microej.converter.vectorimage.generator.raw.element.RawBlock;
import com.microej.converter.vectorimage.generator.raw.element.RawEndGroup;
import com.microej.converter.vectorimage.generator.raw.element.RawGradient;
import com.microej.converter.vectorimage.generator.raw.element.RawGroupAnimate;
import com.microej.converter.vectorimage.generator.raw.element.RawGroupTransform;
import com.microej.converter.vectorimage.generator.raw.element.RawPathColor;
import com.microej.converter.vectorimage.generator.raw.element.RawPathColorAnimate;
import com.microej.converter.vectorimage.generator.raw.element.RawPathData;
import com.microej.converter.vectorimage.generator.raw.element.RawPathGradient;
import com.microej.converter.vectorimage.generator.raw.element.RawPathGradientAnimate;
import com.microej.converter.vectorimage.generator.raw.element.RawPathInterpolator;
import com.microej.converter.vectorimage.generator.raw.element.RawQueueBlock;
import com.microej.converter.vectorimage.vg.VGAlphaAnimation;
import com.microej.converter.vectorimage.vg.VGAnimation;
import com.microej.converter.vectorimage.vg.VGColor;
import com.microej.converter.vectorimage.vg.VGColorAnimation;
import com.microej.converter.vectorimage.vg.VGGradient;
import com.microej.converter.vectorimage.vg.VGGroupAnimate;
import com.microej.converter.vectorimage.vg.VGGroupTransform;
import com.microej.converter.vectorimage.vg.VGPath;
import com.microej.converter.vectorimage.vg.VGPathColor;
import com.microej.converter.vectorimage.vg.VGPathDataAnimation;
import com.microej.converter.vectorimage.vg.VGPathGradient;
import com.microej.converter.vectorimage.vg.VGPathSegment;
import com.microej.converter.vectorimage.vg.VGRotateAnimation;
import com.microej.converter.vectorimage.vg.VGScaleAnimation;
import com.microej.converter.vectorimage.vg.VGTranslateAnimation;
import com.microej.converter.vectorimage.vg.VGTranslateXYAnimation;
import ej.microvg.image.ImageGenerator;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RawGenerator
extends AbstractGenerator {
    public static final int RAW_VERSION = 1;
    private final Map<String, RawPathData> pathDatas;
    private final Map<String, RawPathInterpolator> pathInterpolators;
    private final Map<String, RawPathInterpolator> pathTranslationXY;
    private final ArrayList<RawBlock> gradients;
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final LittleEndianDataOutputStream buffer = new LittleEndianDataOutputStream(this.baos);
    private final File outputFolder;
    private final File outputFile;
    private final ImageGenerator generator;
    private float width;
    private float height;
    private int duration;
    private RawQueueBlock firstElement;
    private RawQueueBlock lastElement;
    private RawAnimationHandler currentAnimationHandler;

    public RawGenerator(String outputFolder, String outputName, ImageGenerator generator) {
        this.pathDatas = new HashMap<String, RawPathData>();
        this.pathInterpolators = new HashMap<String, RawPathInterpolator>();
        this.pathTranslationXY = new HashMap<String, RawPathInterpolator>();
        this.gradients = new ArrayList();
        this.outputFolder = new File(outputFolder);
        this.outputFile = new File(outputFolder, outputName);
        this.generator = generator;
    }

    public int convertColor(VGColor color, float opacity) {
        return this.convertColor(color.getColor(), opacity);
    }

    public int convertColor(Color color, float opacity) {
        return this.generator.encodeColor(color, opacity);
    }

    public byte convertFillRule(boolean fillRule) {
        ImageGenerator.FillRule rule = fillRule ? ImageGenerator.FillRule.FILLRULE_EVENODD : ImageGenerator.FillRule.FILLRULE_NOZERO;
        return rule.toByte();
    }

    @Override
    public void init(float width, float height, boolean hasOverlappingPaths, boolean hierarchical) throws Exception {
        super.init(width, height, hasOverlappingPaths, hierarchical);
        this.width = width;
        this.height = height;
        this.duration = 0;
    }

    private void addRawElementInQueue(RawQueueBlock elem) {
        if (this.firstElement == null) {
            this.lastElement = this.firstElement = elem;
        } else {
            this.lastElement.setNextElement(elem);
            this.lastElement = elem;
        }
    }

    @Override
    public void print(VGGroupTransform vgGroup) throws Exception {
        this.addRawElementInQueue(new RawGroupTransform(vgGroup));
        super.print(vgGroup);
        this.addRawElementInQueue(new RawEndGroup());
    }

    private RawAnimationHandler replaceAnimationHandler(RawAnimationHandler newHandler) {
        RawAnimationHandler oldHandler = this.currentAnimationHandler;
        this.currentAnimationHandler = newHandler;
        return oldHandler;
    }

    @Override
    public void print(VGGroupAnimate vgGroup) throws Exception {
        RawGroupAnimate group = new RawGroupAnimate(vgGroup);
        RawAnimationHandler oldHandler = this.replaceAnimationHandler(group);
        this.addRawElementInQueue(group);
        super.print(vgGroup);
        this.addRawElementInQueue(new RawEndGroup());
        this.duration = Math.max(this.duration, group.getDuration());
        this.replaceAnimationHandler(oldHandler);
    }

    private RawPathInterpolator getRawPathInterpolator(VGAnimation animation) {
        return this.getRawPathInterpolator(this.pathInterpolators, animation.getInterpolatorPathData(), animation.getInterpolatorSegments(), false);
    }

    private RawPathInterpolator getRawPathInterpolatorTranslationXY(VGTranslateXYAnimation animation) {
        return this.getRawPathInterpolator(this.pathTranslationXY, animation.getTranslationPathData(), animation.getTranslationPathSegments(), true);
    }

    private RawPathInterpolator getRawPathInterpolator(Map<String, RawPathInterpolator> pathInterpolators, String desc, List<VGPathSegment> segments, boolean xy) {
        return pathInterpolators.computeIfAbsent(desc, k -> new RawPathInterpolator(segments, xy));
    }

    @Override
    public void print(VGTranslateAnimation animation) {
        this.currentAnimationHandler.setTranslate(new RawAnimation.RawAnimationTranslate(animation, this.getRawPathInterpolator(animation)));
        super.print(animation);
    }

    @Override
    public void print(VGTranslateXYAnimation animation) {
        this.currentAnimationHandler.setTranslateXY(new RawAnimation.RawAnimationTranslateXY(animation, this.getRawPathInterpolator(animation), this.getRawPathInterpolatorTranslationXY(animation)));
        super.print(animation);
    }

    @Override
    public void print(VGRotateAnimation animation) {
        this.currentAnimationHandler.setRotate(new RawAnimation.RawAnimationRotate(animation, this.getRawPathInterpolator(animation)));
        super.print(animation);
    }

    @Override
    public void print(VGScaleAnimation animation) {
        this.currentAnimationHandler.setScale(new RawAnimation.RawAnimationScale(animation, this.getRawPathInterpolator(animation)));
        super.print(animation);
    }

    @Override
    public void print(VGAlphaAnimation animation) {
        this.currentAnimationHandler.setAlpha(new RawAnimation.RawAnimationAlpha(animation, this.getRawPathInterpolator(animation)));
        super.print(animation);
    }

    @Override
    public void print(VGColorAnimation animation) {
        this.currentAnimationHandler.setColor(new RawAnimation.RawAnimationColor(animation, this.getRawPathInterpolator(animation), this));
        super.print(animation);
    }

    @Override
    public void print(VGPathDataAnimation animation) {
        this.currentAnimationHandler.setPathData(new RawAnimation.RawAnimationPathData(animation, this.getRawPathInterpolator(animation), this.getRawPathData(animation.getValueFrom()), this.getRawPathData(animation.getValueTo())));
        super.print(animation);
    }

    @Override
    public void print(VGPath p) throws Exception {
    }

    @Override
    public void printVGPathColorAnimated(VGPathColor p) throws Exception {
        RawPathColorAnimate path = new RawPathColorAnimate(p, this.getRawPathData(p), this);
        RawAnimationHandler oldHandler = this.replaceAnimationHandler(path);
        this.addRawElementInQueue(path);
        super.printVGPathColorAnimated(p);
        this.duration = Math.max(this.duration, path.getDuration());
        this.replaceAnimationHandler(oldHandler);
    }

    @Override
    public void printVGPathColorNotAnimated(VGPathColor p) throws Exception {
        this.addRawElementInQueue(new RawPathColor(p, this.getRawPathData(p), this));
        super.printVGPathColorNotAnimated(p);
    }

    @Override
    public void printVGPathGradientAnimated(VGPathGradient p) throws Exception {
        RawPathGradientAnimate path = new RawPathGradientAnimate(p, this.getRawPathData(p), this.createRawGradient(p), this);
        RawAnimationHandler oldHandler = this.replaceAnimationHandler(path);
        this.addRawElementInQueue(path);
        super.printVGPathGradientAnimated(p);
        this.duration = Math.max(this.duration, path.getDuration());
        this.replaceAnimationHandler(oldHandler);
    }

    @Override
    public void printVGPathGradientNotAnimated(VGPathGradient p) throws Exception {
        this.addRawElementInQueue(new RawPathGradient(p, this.getRawPathData(p), this.createRawGradient(p), this));
        super.printVGPathGradientNotAnimated(p);
    }

    private RawGradient createRawGradient(VGPathGradient p) {
        RawGradient g = this.newRawGradient(p.getStyle().getGradient(), this.getRawPathData(p));
        this.gradients.add(g);
        return g;
    }

    public RawGradient newRawGradient(VGGradient gradient, RawPathData pathData) {
        if (0.0 == Math.sqrt(Math.pow(gradient.getXEnd() - gradient.getXStart(), 2.0) + Math.pow(gradient.getYEnd() - gradient.getYStart(), 2.0))) {
            gradient.setX1((float)pathData.getPath().getTopLeftPoint().getX());
            gradient.setX2((float)pathData.getPath().getBottomRightPoint().getX());
            gradient.setY1(0.0f);
            gradient.setY2(0.0f);
        }
        return new RawGradient(this.generator.encodeGradient(gradient));
    }

    @Override
    public void end() throws Exception {
        this.encodeFileHeader();
        this.encodePathData();
        this.encodePathInterpolators(this.pathInterpolators);
        this.encodePathInterpolators(this.pathTranslationXY);
        this.encodeRawData(this.gradients);
        this.encodeElements();
        this.encodeLastElement();
        this.buffer.flush();
        this.outputFolder.mkdirs();
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileOutputStream outputStream = new FileOutputStream(this.outputFile);){
            outputStream.write(this.baos.toByteArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.baos.close();
    }

    private RawPathData getRawPathData(VGPath p) {
        return this.getRawPathData(p.getPathData());
    }

    private RawPathData getRawPathData(String pathData) {
        RawPathData rawPathData = new RawPathData(PathBufferParser.getPath(pathData, this.generator), this.generator);
        return this.pathDatas.computeIfAbsent(pathData, k -> rawPathData);
    }

    private int getDataSize() {
        int dataSize = 0;
        for (RawPathData rawPathData : this.pathDatas.values()) {
            dataSize += rawPathData.getEncodedSize();
        }
        for (RawPathInterpolator rawPathInterpolator : this.pathInterpolators.values()) {
            dataSize += rawPathInterpolator.getEncodedSize();
        }
        for (RawPathInterpolator rawPathInterpolator : this.pathTranslationXY.values()) {
            dataSize += rawPathInterpolator.getEncodedSize();
        }
        for (RawBlock rawBlock : this.gradients) {
            dataSize += rawBlock.getEncodedSize();
        }
        return RawUtils.align32(dataSize);
    }

    private void encodeFileHeader() throws IOException {
        this.buffer.writeByte(77);
        this.buffer.writeByte(69);
        this.buffer.writeByte(74);
        this.buffer.writeByte(95);
        this.buffer.writeByte(77);
        this.buffer.writeByte(86);
        this.buffer.writeByte(71);
        this.buffer.writeByte(1);
        this.buffer.writeFloat(this.width);
        this.buffer.writeFloat(this.height);
        this.buffer.writeInt((this.hasOverlappingPaths ? Integer.MIN_VALUE : 0) | this.duration & 0xFFFFFF);
        this.buffer.writeInt(this.buffer.getOffset() + 4 + this.getDataSize());
    }

    private void encodePathData() throws IOException {
        for (RawPathData data : this.pathDatas.values()) {
            data.encode(this.buffer);
        }
        RawUtils.addPadding(this.buffer);
    }

    private void encodeElements() throws IOException {
        RawQueueBlock element = this.firstElement;
        while (element != null) {
            element.encode(this.buffer);
            RawUtils.addPadding(this.buffer);
            element = element.getNextElement();
        }
    }

    private void encodePathInterpolators(Map<String, RawPathInterpolator> pathInterpolators) throws IOException {
        for (RawPathInterpolator data : pathInterpolators.values()) {
            data.encode(this.buffer);
        }
        RawUtils.addPadding(this.buffer);
    }

    private void encodeRawData(ArrayList<RawBlock> list) throws IOException {
        for (RawBlock data : list) {
            data.encode(this.buffer);
        }
        RawUtils.addPadding(this.buffer);
    }

    private void encodeLastElement() throws IOException {
        this.buffer.writeByte(0);
    }
}

