/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator.raw;

import com.microej.converter.vectorimage.Logger;
import com.microej.converter.vectorimage.generator.raw.model.Close;
import com.microej.converter.vectorimage.generator.raw.model.CubicTo;
import com.microej.converter.vectorimage.generator.raw.model.LineTo;
import com.microej.converter.vectorimage.generator.raw.model.MoveTo;
import com.microej.converter.vectorimage.generator.raw.model.PathImpl;
import com.microej.converter.vectorimage.generator.raw.model.Point;
import com.microej.converter.vectorimage.generator.raw.model.QuadTo;
import ej.microvg.image.ImageGenerator;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathHandler;
import org.apache.batik.parser.PathParser;

public class PathBufferParser {
    public static PathImpl getPath(String path, ImageGenerator generator) {
        PathParser pp = new PathParser();
        MyPathHandler handler = new MyPathHandler(generator);
        pp.setPathHandler(handler);
        try {
            pp.parse(path);
        }
        catch (ParseException parseException) {
            path = path.replaceAll("c\\s+", "");
            pp.parse(path);
        }
        return handler.path;
    }

    private static class MyPathHandler
    implements PathHandler {
        private final PathImpl path;
        private Point ctrl;
        private Point pos;

        public MyPathHandler(ImageGenerator generator) {
            this.path = new PathImpl(generator);
        }

        @Override
        public void startPath() throws ParseException {
            this.pos = new Point(0.0, 0.0);
        }

        @Override
        public void endPath() throws ParseException {
            this.path.add(new Close());
        }

        @Override
        public void arcAbs(float arg0, float arg1, float arg2, boolean arg3, boolean arg4, float arg5, float arg6) throws ParseException {
            Logger.logWarnString("Unsupported absolute arc in paths. It must be converted to a curve, refer to the documentation for more information.");
        }

        @Override
        public void arcRel(float arg0, float arg1, float arg2, boolean arg3, boolean arg4, float arg5, float arg6) throws ParseException {
            Logger.logWarnString("Unsupported relative arc in paths. It must be converted to a curve, refer to the documentation for more information.");
        }

        @Override
        public void curvetoCubicAbs(float arg0, float arg1, float arg2, float arg3, float arg4, float arg5) throws ParseException {
            Point c1Abs = new Point(arg0, arg1);
            Point c2Abs = new Point(arg2, arg3);
            Point dstAbs = new Point(arg4, arg5);
            this.path.add(new CubicTo(c1Abs, c2Abs, dstAbs, false));
            this.ctrl = c2Abs;
            this.pos = dstAbs;
        }

        @Override
        public void curvetoCubicRel(float arg0, float arg1, float arg2, float arg3, float arg4, float arg5) throws ParseException {
            Point c1Rel = new Point(arg0, arg1);
            Point c2Rel = new Point(arg2, arg3);
            Point dstRel = new Point(arg4, arg5);
            this.path.add(new CubicTo(c1Rel, c2Rel, dstRel, true));
            this.ctrl = this.pos.add(c2Rel);
            this.pos = this.pos.add(dstRel);
        }

        @Override
        public void curvetoCubicSmoothAbs(float arg0, float arg1, float arg2, float arg3) throws ParseException {
            Point c1Abs = this.pos.mul(2.0).sub(this.ctrl);
            Point c2Abs = new Point(arg0, arg1);
            Point dstAbs = new Point(arg2, arg3);
            this.path.add(new CubicTo(c1Abs, c2Abs, dstAbs, false));
            this.ctrl = c2Abs;
            this.pos = dstAbs;
        }

        @Override
        public void curvetoCubicSmoothRel(float arg0, float arg1, float arg2, float arg3) throws ParseException {
            Point c1Rel = this.pos.sub(this.ctrl);
            Point c2Rel = new Point(arg0, arg1);
            Point dstRel = new Point(arg2, arg3);
            this.path.add(new CubicTo(c1Rel, c2Rel, dstRel, true));
            this.ctrl = this.pos.add(c2Rel);
            this.pos = this.pos.add(dstRel);
        }

        @Override
        public void curvetoQuadraticAbs(float arg0, float arg1, float arg2, float arg3) throws ParseException {
            Point ctrlAbs = new Point(arg0, arg1);
            Point dstAbs = new Point(arg2, arg3);
            this.path.add(new QuadTo(ctrlAbs, dstAbs, false));
            this.ctrl = ctrlAbs;
            this.pos = dstAbs;
        }

        @Override
        public void curvetoQuadraticRel(float arg0, float arg1, float arg2, float arg3) throws ParseException {
            Point ctrlRel = new Point(arg0, arg1);
            Point dstRel = new Point(arg2, arg3);
            this.path.add(new QuadTo(ctrlRel, dstRel, true));
            this.ctrl = this.pos.add(ctrlRel);
            this.pos = this.pos.add(dstRel);
        }

        @Override
        public void curvetoQuadraticSmoothAbs(float arg0, float arg1) throws ParseException {
            Point ctrlAbs = this.pos.mul(2.0).sub(this.ctrl);
            Point dstAbs = new Point(arg0, arg1);
            this.path.add(new QuadTo(ctrlAbs, dstAbs, false));
            this.ctrl = ctrlAbs;
            this.pos = dstAbs;
        }

        @Override
        public void curvetoQuadraticSmoothRel(float arg0, float arg1) throws ParseException {
            Point ctrlRel = this.pos.sub(this.ctrl);
            Point dstRel = new Point(arg0, arg1);
            this.path.add(new QuadTo(ctrlRel, dstRel, true));
            this.ctrl = this.pos.add(ctrlRel);
            this.pos = this.pos.add(dstRel);
        }

        @Override
        public void linetoAbs(float arg0, float arg1) throws ParseException {
            Point dstAbs = new Point(arg0, arg1);
            this.path.add(new LineTo(dstAbs, false));
            this.pos = dstAbs;
        }

        @Override
        public void linetoHorizontalAbs(float arg0) throws ParseException {
            Point dstAbs = new Point(arg0, this.pos.getY());
            this.path.add(new LineTo(dstAbs, false));
            this.pos = dstAbs;
        }

        @Override
        public void linetoHorizontalRel(float arg0) throws ParseException {
            Point dstRel = new Point(arg0, 0.0);
            this.path.add(new LineTo(dstRel, true));
            this.pos = this.pos.add(dstRel);
        }

        @Override
        public void linetoRel(float arg0, float arg1) throws ParseException {
            Point dstRel = new Point(arg0, arg1);
            this.path.add(new LineTo(dstRel, true));
            this.pos = this.pos.add(dstRel);
        }

        @Override
        public void linetoVerticalAbs(float arg0) throws ParseException {
            Point dstAbs = new Point(this.pos.getX(), arg0);
            this.path.add(new LineTo(dstAbs, false));
            this.pos = dstAbs;
        }

        @Override
        public void linetoVerticalRel(float arg0) throws ParseException {
            Point dstRel = new Point(0.0, arg0);
            this.path.add(new LineTo(dstRel, true));
            this.pos = this.pos.add(dstRel);
        }

        @Override
        public void movetoAbs(float arg0, float arg1) throws ParseException {
            this.pos = new Point(arg0, arg1);
            this.path.add(new MoveTo(this.pos, false));
        }

        @Override
        public void movetoRel(float arg0, float arg1) throws ParseException {
            Point dstRel = new Point(arg0, arg1);
            this.path.add(new MoveTo(dstRel, true));
            this.pos = this.pos.add(dstRel);
        }

        @Override
        public void closePath() throws ParseException {
        }
    }
}

