/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator.raw;

import com.microej.converter.vectorimage.Logger;
import com.microej.converter.vectorimage.generator.raw.model.AbstractCommand;
import com.microej.converter.vectorimage.generator.raw.model.Close;
import com.microej.converter.vectorimage.generator.raw.model.CubicTo;
import com.microej.converter.vectorimage.generator.raw.model.LineTo;
import com.microej.converter.vectorimage.generator.raw.model.MoveTo;
import com.microej.converter.vectorimage.generator.raw.model.PathImpl;
import com.microej.converter.vectorimage.generator.raw.model.Point;
import com.microej.converter.vectorimage.generator.raw.model.QuadTo;
import ej.microvg.image.ImageGenerator;
import ej.microvg.image.pathdata.PathData;
import java.util.Iterator;

public class PathBufferEncoder {
    public static void encode(ImageGenerator generator, PathImpl path, PathData pathData) {
        pathData.reset();
        PathBufferEncoder.checkFormat(path, pathData.getFormat());
        for (AbstractCommand cmd : path) {
            if (cmd instanceof MoveTo) {
                PathBufferEncoder.moveTo(generator, pathData, (MoveTo)cmd);
                continue;
            }
            if (cmd instanceof LineTo) {
                PathBufferEncoder.lineTo(generator, pathData, (LineTo)cmd);
                continue;
            }
            if (cmd instanceof QuadTo) {
                PathBufferEncoder.quadTo(generator, pathData, (QuadTo)cmd);
                continue;
            }
            if (cmd instanceof CubicTo) {
                PathBufferEncoder.cubicTo(generator, pathData, (CubicTo)cmd);
                continue;
            }
            if (!(cmd instanceof Close)) continue;
            PathBufferEncoder.close(generator, pathData, (Close)cmd);
        }
    }

    private static void moveTo(ImageGenerator generator, PathData buffer, MoveTo cmd) {
        boolean relative = cmd.isRelative();
        Point vgPoint = cmd.get(0);
        if (relative) {
            PathBufferEncoder.moveRel(generator, buffer, (float)vgPoint.getX(), (float)vgPoint.getY());
        } else {
            PathBufferEncoder.move(generator, buffer, (float)vgPoint.getX(), (float)vgPoint.getY());
        }
    }

    private static void lineTo(ImageGenerator generator, PathData buffer, LineTo cmd) {
        boolean relative = cmd.isRelative();
        Point vgPoint = cmd.get(0);
        if (relative) {
            PathBufferEncoder.lineRel(generator, buffer, (float)vgPoint.getX(), (float)vgPoint.getY());
        } else {
            PathBufferEncoder.line(generator, buffer, (float)vgPoint.getX(), (float)vgPoint.getY());
        }
    }

    private static void quadTo(ImageGenerator generator, PathData buffer, QuadTo cmd) {
        boolean relative = cmd.isRelative();
        Point vgPoint = cmd.get(1);
        Point vgControl = cmd.get(0);
        if (relative) {
            PathBufferEncoder.quadRel(generator, buffer, (float)vgControl.getX(), (float)vgControl.getY(), (float)vgPoint.getX(), (float)vgPoint.getY());
        } else {
            PathBufferEncoder.quad(generator, buffer, (float)vgControl.getX(), (float)vgControl.getY(), (float)vgPoint.getX(), (float)vgPoint.getY());
        }
    }

    private static void cubicTo(ImageGenerator generator, PathData buffer, CubicTo cmd) {
        boolean relative = cmd.isRelative();
        Point vgPoint = cmd.get(2);
        Point vgControl1 = cmd.get(0);
        Point vgControl2 = cmd.get(1);
        if (relative) {
            PathBufferEncoder.cubicRel(generator, buffer, (float)vgControl1.getX(), (float)vgControl1.getY(), (float)vgControl2.getX(), (float)vgControl2.getY(), (float)vgPoint.getX(), (float)vgPoint.getY());
        } else {
            PathBufferEncoder.cubic(generator, buffer, (float)vgControl1.getX(), (float)vgControl1.getY(), (float)vgControl2.getX(), (float)vgControl2.getY(), (float)vgPoint.getX(), (float)vgPoint.getY());
        }
    }

    private static void close(ImageGenerator generator, PathData buffer, Close cmd) {
        PathBufferEncoder.close(generator, buffer);
    }

    private static void close(ImageGenerator generator, PathData buffer) {
        PathBufferEncoder.command(buffer, generator.encodeCommand(ImageGenerator.Command.COMMAND_CLOSE));
    }

    private static void command(PathData buffer, int cmd) {
        PathBufferEncoder.appendCommand(buffer, cmd);
    }

    private static void move(ImageGenerator generator, PathData buffer, double x, double y) {
        PathBufferEncoder.command(buffer, generator.encodeCommand(ImageGenerator.Command.COMMAND_MOVE), x, y);
    }

    private static void moveRel(ImageGenerator generator, PathData buffer, double x, double y) {
        PathBufferEncoder.command(buffer, generator.encodeCommand(ImageGenerator.Command.COMMAND_MOVE_REL), x, y);
    }

    private static void line(ImageGenerator generator, PathData buffer, double x, double y) {
        PathBufferEncoder.command(buffer, generator.encodeCommand(ImageGenerator.Command.COMMAND_LINE), x, y);
    }

    private static void lineRel(ImageGenerator generator, PathData buffer, double x, double y) {
        PathBufferEncoder.command(buffer, generator.encodeCommand(ImageGenerator.Command.COMMAND_LINE_REL), x, y);
    }

    private static void command(PathData buffer, int cmd, double x, double y) {
        PathBufferEncoder.appendCommand(buffer, cmd);
        PathBufferEncoder.appendCoordinate(buffer, x);
        PathBufferEncoder.appendCoordinate(buffer, y);
    }

    private static void quad(ImageGenerator generator, PathData buffer, double cx, double cy, double x, double y) {
        PathBufferEncoder.command(buffer, generator.encodeCommand(ImageGenerator.Command.COMMAND_QUAD), cx, cy, x, y);
    }

    private static void quadRel(ImageGenerator generator, PathData buffer, double cx, double cy, double x, double y) {
        PathBufferEncoder.command(buffer, generator.encodeCommand(ImageGenerator.Command.COMMAND_QUAD_REL), cx, cy, x, y);
    }

    private static void command(PathData buffer, int cmd, double x1, double y1, double x2, double y2) {
        PathBufferEncoder.appendCommand(buffer, cmd);
        PathBufferEncoder.appendCoordinate(buffer, x1);
        PathBufferEncoder.appendCoordinate(buffer, y1);
        PathBufferEncoder.appendCoordinate(buffer, x2);
        PathBufferEncoder.appendCoordinate(buffer, y2);
    }

    private static void cubic(ImageGenerator generator, PathData buffer, double cx1, double cy1, double cx2, double cy2, double x, double y) {
        PathBufferEncoder.command(buffer, generator.encodeCommand(ImageGenerator.Command.COMMAND_CUBIC), cx1, cy1, cx2, cy2, x, y);
    }

    private static void cubicRel(ImageGenerator generator, PathData buffer, double cx1, double cy1, double cx2, double cy2, double x, double y) {
        PathBufferEncoder.command(buffer, generator.encodeCommand(ImageGenerator.Command.COMMAND_CUBIC_REL), cx1, cy1, cx2, cy2, x, y);
    }

    private static void command(PathData buffer, int cmd, double x1, double y1, double x2, double y2, double x3, double y3) {
        PathBufferEncoder.appendCommand(buffer, cmd);
        PathBufferEncoder.appendCoordinate(buffer, x1);
        PathBufferEncoder.appendCoordinate(buffer, y1);
        PathBufferEncoder.appendCoordinate(buffer, x2);
        PathBufferEncoder.appendCoordinate(buffer, y2);
        PathBufferEncoder.appendCoordinate(buffer, x3);
        PathBufferEncoder.appendCoordinate(buffer, y3);
    }

    private static void appendCommand(PathData buffer, int command) {
        buffer.appendCommand(command);
    }

    private static void appendCoordinate(PathData buffer, double coordinate) {
        buffer.appendCoordinate(coordinate);
    }

    private static void checkFormat(PathImpl path, ImageGenerator.Format format) {
        double min = 0.0;
        double max = 0.0;
        switch (format) {
            case VG_S8: {
                max = Math.pow(2.0, 8.0) - 1.0;
                break;
            }
            case VG_S16: {
                max = Math.pow(2.0, 16.0) - 1.0;
                break;
            }
            case VG_S32: {
                max = Math.pow(2.0, 32.0) - 1.0;
                break;
            }
            default: {
                return;
            }
        }
        Iterator<AbstractCommand> iterator = path.iterator();
        while (iterator.hasNext()) {
            AbstractCommand command;
            AbstractCommand abstractCommand = command = iterator.next();
            for (Point point : abstractCommand) {
                if (point.getX() < min || point.getX() > max) {
                    Logger.logErrString("Coordinate " + point.getX() + " does not fit the selected format. Coordinates value must be between " + min + " and " + max);
                }
                if (!(point.getY() < min) && !(point.getY() > max)) continue;
                Logger.logErrString("Coordinate " + point.getY() + " does not fit the selected format. Coordinates value must be between " + min + " and " + max);
            }
        }
    }
}

