/*
 * Decompiled with CFR 0.152.
 */
package com.microej.converter.vectorimage.generator.raw;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    private int offset = 0;

    public LittleEndianDataOutputStream(OutputStream out) {
        super(new DataOutputStream(out));
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        ++this.offset;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.offset += len;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        ((DataOutputStream)this.out).writeBoolean(v);
        ++this.offset;
    }

    @Override
    public void writeByte(int v) throws IOException {
        ((DataOutputStream)this.out).writeByte(v);
        ++this.offset;
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.write(0xFF & v);
        this.out.write(0xFF & v >> 8);
        this.offset += 2;
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.out.write(0xFF & v);
        this.out.write(0xFF & v >> 8);
        this.out.write(0xFF & v >> 16);
        this.out.write(0xFF & v >> 24);
        this.offset += 4;
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.writeInt((int)v);
        this.writeInt((int)(v >> 32));
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        throw new IOException("TODO");
    }

    @Override
    public void writeChars(String s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            this.writeChar(s.charAt(i));
            ++i;
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        throw new IOException("TODO");
    }

    public int getOffset() {
        return this.offset;
    }
}

